/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterUserMapperHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(RegisterUserMapperHandler.class);
    private static final String OS_PROPERTY_ENTRY = "OSPropertyEntry";
    private static final String ENTITY_NAME = "entityName";
    private static final String APPLICATION_USER = "ApplicationUser";
    private static final String USER = "User";
    private static final String ID = "id";
    private static final String ENTITY_ID = "entityId";
    private static final String OS_PROPERTY_STRING = "OSPropertyString";
    private static final String VALUE = "value";
    private static final String USER_KEY = "userKey";
    private static final String USER_NAME = "userName";
    private static final String LOWER_USER_NAME = "lowerUserName";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL = "emailAddress";
    private static final String CREDENTIAL = "credential";
    private final Map<String, String> appUserIdToUserKeyMap = new HashMap<String, String>();
    private final Map<String, UserPropertyKey> osPropertyEntryMap = new HashMap<String, UserPropertyKey>();
    private final Map<String, String> userNameToUserKeyMap = new HashMap<String, String>();
    private final Map<String, ExternalUser> userMap = new HashMap<String, ExternalUser>();
    private final UserMapper userMapper;
    private final boolean debug;

    public RegisterUserMapperHandler(UserMapper userMapper) {
        this.userMapper = userMapper;
        this.debug = log.isDebugEnabled();
    }

    private void handleApplicationUser(Map<String, String> attributes) throws ParseException {
        String id = attributes.get(ID);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("Missing 'id' field for ApplicationUser entry.");
        }
        String userKey = attributes.get(USER_KEY);
        if (StringUtils.isEmpty((String)userKey)) {
            throw new ParseException("Missing userKey from ApplicationUser id = " + id);
        }
        String lowerUserName = attributes.get(LOWER_USER_NAME);
        if (StringUtils.isEmpty((String)lowerUserName)) {
            throw new ParseException("Missing lowerUserName from ApplicationUser id = " + id);
        }
        this.appUserIdToUserKeyMap.put(id, userKey);
        this.userNameToUserKeyMap.put(lowerUserName, userKey);
    }

    private void handleOsPropertyEntry(Map<String, String> attributes) throws ParseException {
        if (!APPLICATION_USER.equals(attributes.get(ENTITY_NAME))) {
            return;
        }
        String osPropertyID = attributes.get(ID);
        if (StringUtils.isEmpty((String)osPropertyID)) {
            throw new ParseException("Missing 'id' field for OSPropertyEntry.");
        }
        String entityId = attributes.get(ENTITY_ID);
        if (StringUtils.isBlank((String)entityId)) {
            throw new ParseException("Missing entityId from OSPropertyEntry id = " + osPropertyID);
        }
        String propertyKey = attributes.get("propertyKey");
        if (StringUtils.isBlank((String)propertyKey)) {
            throw new ParseException("Missing propertyKey from OSPropertyEntry id = " + osPropertyID);
        }
        String userKey = this.appUserIdToUserKeyMap.get(entityId);
        if (userKey == null) {
            log.warn("OSPropertyEntry " + osPropertyID + " is associated with non-existent ApplicationUser ID '" + entityId + '\'');
        } else if (UserPropertyKey.isRememberedPropertyKey(propertyKey)) {
            this.osPropertyEntryMap.put(osPropertyID, new UserPropertyKey(userKey, propertyKey));
            if (this.debug) {
                log.debug("Registering property '" + propertyKey + "' belonging to userKey='" + userKey + '\'');
            }
        } else if (this.debug) {
            log.debug("Ignoring property '" + propertyKey + "' belonging to userKey='" + userKey + '\'');
        }
    }

    private void handleOsPropertyString(Map<String, String> attributes) throws ParseException {
        UserPropertyKey userPropertyKey = this.osPropertyEntryMap.remove(attributes.get(ID));
        if (userPropertyKey != null) {
            userPropertyKey.addPropertyValueToUser(this.externalUser(userPropertyKey.userKey), attributes.get(VALUE));
            if (this.debug) {
                log.debug("User key '" + userPropertyKey.userKey + "' has property '" + userPropertyKey.propertyKey + "' with value '" + attributes.get(VALUE));
            }
        } else if (this.debug) {
            log.debug("OSPropertyString with id '" + attributes.get(ID) + "' did not have an OSPropertyEntry that we cared about");
        }
    }

    private void handleUser(Map<String, String> attributes) throws ParseException {
        String email;
        String userId = attributes.get(ID);
        if (StringUtils.isEmpty((String)userId)) {
            throw new ParseException("Missing 'id' field for User entry.");
        }
        String name = attributes.get(USER_NAME);
        if (StringUtils.isEmpty((String)name)) {
            log.warn("Missing 'userName' field for User entry id = " + userId);
            return;
        }
        String displayName = attributes.get(DISPLAY_NAME);
        if (StringUtils.isEmpty((String)displayName)) {
            log.warn("Missing 'displayName' field for User entry id = " + userId);
        }
        if (StringUtils.isEmpty((String)(email = attributes.get(EMAIL)))) {
            log.warn("Missing 'email' field for User entry id = " + userId);
        }
        String credential = attributes.get(CREDENTIAL);
        String userKey = this.keyForUserName(name);
        ExternalUser externalUser = this.externalUser(userKey);
        externalUser.setId(userId);
        externalUser.setName(name);
        externalUser.setFullname(displayName);
        externalUser.setEmail(email);
        externalUser.setPasswordHash(credential);
        this.userMapper.registerOldValue(externalUser);
        if (this.debug) {
            log.debug("Registering user '" + name + "' for creation");
        }
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if (entityName.equals(APPLICATION_USER)) {
            this.handleApplicationUser(attributes);
        } else if (entityName.equals(OS_PROPERTY_ENTRY)) {
            this.handleOsPropertyEntry(attributes);
        } else if (entityName.equals(OS_PROPERTY_STRING)) {
            this.handleOsPropertyString(attributes);
        } else if (entityName.equals(USER)) {
            this.handleUser(attributes);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    private ExternalUser externalUser(String userKey) {
        ExternalUser user = this.userMap.get(userKey);
        if (user == null) {
            user = new ExternalUser();
            user.setKey(userKey);
            this.userMap.put(userKey, user);
        }
        return user;
    }

    private String keyForUserName(String userName) {
        String lowerUserName = IdentifierUtils.toLowerCase((String)userName);
        if (!this.userNameToUserKeyMap.isEmpty()) {
            String userKey = this.userNameToUserKeyMap.get(lowerUserName);
            if (userKey != null) {
                return userKey;
            }
            log.warn("ApplicationUser entities are present, but User '" + userName + "' does not have one.");
        }
        return IdentifierUtils.toLowerCase((String)userName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterUserMapperHandler that = (RegisterUserMapperHandler)o;
        if (this.userMapper != null ? !this.userMapper.equals(that.userMapper) : that.userMapper != null) {
            return false;
        }
        return this.appUserIdToUserKeyMap.equals(that.appUserIdToUserKeyMap) && this.osPropertyEntryMap.equals(that.osPropertyEntryMap) && this.userNameToUserKeyMap.equals(that.userNameToUserKeyMap) && this.userMap.equals(that.userMap);
    }

    public int hashCode() {
        int result = this.userMapper != null ? this.userMapper.hashCode() : 0;
        result = 31 * result + this.appUserIdToUserKeyMap.hashCode();
        result = 31 * result + this.osPropertyEntryMap.hashCode();
        result = 31 * result + this.userNameToUserKeyMap.hashCode();
        result = 31 * result + this.userMap.hashCode();
        return result;
    }

    static class UserPropertyKey {
        String userKey;
        String propertyKey;

        public UserPropertyKey(String userKey, String propertyKey) {
            this.userKey = userKey;
            this.propertyKey = propertyKey;
        }

        public void addPropertyValueToUser(ExternalUser externalUser, String value) {
            if (UserPropertyKey.isRememberedPropertyKey(this.propertyKey)) {
                String simplePropertyKey = this.propertyKey.substring("jira.meta.".length());
                externalUser.setUserProperty(simplePropertyKey, value);
            }
        }

        public static boolean isRememberedPropertyKey(String propertyKey) {
            return propertyKey.startsWith("jira.meta.");
        }
    }
}

