/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.UserAssociationParser;
import com.atlassian.jira.imports.project.parser.UserAssociationParserImpl;
import com.atlassian.jira.imports.project.transformer.VoterTransformer;
import com.atlassian.jira.imports.project.transformer.VoterTransformerImpl;
import com.atlassian.jira.imports.project.transformer.WatcherTransformer;
import com.atlassian.jira.imports.project.transformer.WatcherTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAssociationPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(UserAssociationPersisterHandler.class);
    private WatcherTransformer watcherTransformer;
    private VoterTransformer voterTransformer;
    private UserAssociationParser userAssociationParser;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;

    public UserAssociationPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportMapper = projectImportMapper;
        this.projectImportPersister = projectImportPersister;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("UserAssociation".equals(entityName)) {
            ExternalWatcher externalWatcher;
            ExternalVoter externalVoter = this.getUserAssociationParser().parseVoter(attributes);
            if (externalVoter != null) {
                this.saveVoter(externalVoter);
            }
            if ((externalWatcher = this.getUserAssociationParser().parseWatcher(attributes)) != null) {
                this.saveWatcher(externalWatcher);
            }
        }
    }

    void saveWatcher(final ExternalWatcher externalWatcher) throws AbortImportException {
        final ExternalWatcher transformedWatcher = this.getWatcherTransformer().transform(this.projectImportMapper, externalWatcher);
        if (transformedWatcher.getIssueId() != null) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    if (!UserAssociationPersisterHandler.this.projectImportPersister.createWatcher(transformedWatcher)) {
                        String issueKey = UserAssociationPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalWatcher.getIssueId());
                        UserAssociationPersisterHandler.this.projectImportResults.addError(UserAssociationPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.watcher.error", externalWatcher.getWatcher(), issueKey));
                    }
                }
            });
        } else {
            String issueKey = this.backupSystemInformation.getIssueKeyForId(externalWatcher.getIssueId());
            log.warn("No watcher association for watcher '" + externalWatcher.getWatcher() + "' for issue '" + issueKey + "', the issue has not been mapped into the current instance of JIRA.");
        }
    }

    void saveVoter(final ExternalVoter externalVoter) throws AbortImportException {
        final ExternalVoter transformedVoter = this.getVoterTransformer().transform(this.projectImportMapper, externalVoter);
        if (transformedVoter.getIssueId() != null) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    if (!UserAssociationPersisterHandler.this.projectImportPersister.createVoter(transformedVoter)) {
                        String issueKey = UserAssociationPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalVoter.getIssueId());
                        UserAssociationPersisterHandler.this.projectImportResults.addError(UserAssociationPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.voter.error", externalVoter.getVoter(), issueKey));
                    }
                }
            });
        } else {
            String issueKey = this.backupSystemInformation.getIssueKeyForId(externalVoter.getIssueId());
            log.warn("No voter association for voter '" + externalVoter.getVoter() + "' for issue '" + issueKey + "', the issue has not been mapped into the current instance of JIRA.");
        }
    }

    UserAssociationParser getUserAssociationParser() {
        if (this.userAssociationParser == null) {
            this.userAssociationParser = new UserAssociationParserImpl();
        }
        return this.userAssociationParser;
    }

    WatcherTransformer getWatcherTransformer() {
        if (this.watcherTransformer == null) {
            this.watcherTransformer = new WatcherTransformerImpl();
        }
        return this.watcherTransformer;
    }

    VoterTransformer getVoterTransformer() {
        if (this.voterTransformer == null) {
            this.voterTransformer = new VoterTransformerImpl();
        }
        return this.voterTransformer;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

