/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalWorklog;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.WorklogParser;
import com.atlassian.jira.imports.project.parser.WorklogParserImpl;
import com.atlassian.jira.imports.project.transformer.WorklogTransformer;
import com.atlassian.jira.imports.project.transformer.WorklogTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorklogPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(WorklogPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private WorklogParser worklogParser;
    private WorklogTransformer worklogTransformer;

    public WorklogPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("Worklog".equals(entityName)) {
            final ExternalWorklog externalWorklog = this.getWorklogParser().parse(attributes);
            final ExternalWorklog transformedExternalWorklog = this.getWorklogTransformer().transform(this.projectImportMapper, externalWorklog);
            if (transformedExternalWorklog.getIssueId() != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long worklogId = WorklogPersisterHandler.this.projectImportPersister.createEntity(WorklogPersisterHandler.this.getWorklogParser().getEntityRepresentation(transformedExternalWorklog));
                        if (worklogId == null) {
                            String issueKey = WorklogPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalWorklog.getIssueId());
                            WorklogPersisterHandler.this.projectImportResults.addError(WorklogPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.worklog.error", externalWorklog.getId(), issueKey));
                        }
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalWorklog.getIssueId());
                log.warn("Not saving worklog '" + externalWorklog.getId() + "' it appears that the issue '" + issueKey + "' was not created as part of the import.");
            }
        }
    }

    WorklogParser getWorklogParser() {
        if (this.worklogParser == null) {
            this.worklogParser = new WorklogParserImpl();
        }
        return this.worklogParser;
    }

    WorklogTransformer getWorklogTransformer() {
        if (this.worklogTransformer == null) {
            this.worklogTransformer = new WorklogTransformerImpl();
        }
        return this.worklogTransformer;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

