/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;

public class IssueSecurityLevelValidator {
    private final ProjectManager projectManager;

    public IssueSecurityLevelValidator(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public MessageSet validateMappings(SimpleProjectImportIdMapper issueSecurityLevelMapper, BackupProject backupProject, I18nHelper i18nHelper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        for (String oldId : issueSecurityLevelMapper.getRequiredOldIds()) {
            String newId = issueSecurityLevelMapper.getMappedId(oldId);
            if (newId != null) continue;
            if (issueSecurityLevelMapper.getKey(oldId) == null) {
                messageSet.addWarningMessage(i18nHelper.getText("admin.warning.project.import.issue.security.level.validation.orphan", oldId));
                messageSet.addWarningMessageInEnglish("The issue security level '" + oldId + "' can not be resolved into an actual security level in the backup file. Any issues that were protected by this security level will no longer have an issue security level.");
                continue;
            }
            if (this.projectExists(backupProject)) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.security.level.validation.does.not.exist.project.exists", issueSecurityLevelMapper.getDisplayName(oldId)));
                messageSet.addErrorMessageInEnglish("The Issue Security Level '" + issueSecurityLevelMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
                continue;
            }
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issue.security.level.validation.does.not.exist.project.doesnt.exist", issueSecurityLevelMapper.getDisplayName(oldId), backupProject.getProject().getKey()));
            messageSet.addErrorMessageInEnglish("The Issue Security Level '" + issueSecurityLevelMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
        }
        return messageSet;
    }

    boolean projectExists(BackupProject backupProject) {
        return this.projectManager.getProjectObjByKey(backupProject.getProject().getKey()) != null;
    }
}

