/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.instrumentation.Counter;
import com.atlassian.jira.index.DelayCloseable;
import com.atlassian.jira.index.DelegateSearcher;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.util.Closeable;
import com.atlassian.jira.util.CompositeCloseable;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.lucene.search.IndexSearcher;

class DelayCloseSearcher
extends DelegateSearcher
implements DelayCloseable {
    private final DelayCloseable.Helper helper;

    DelayCloseSearcher(@Nonnull IndexSearcher searcher) {
        super((IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher));
        this.helper = new DelayCloseable.Helper(new SearcherCloser(searcher));
    }

    DelayCloseSearcher(@Nonnull IndexSearcher searcher, @Nonnull Closeable closeAction) {
        super((IndexSearcher)Assertions.notNull((String)"searcher", (Object)searcher));
        this.helper = new DelayCloseable.Helper(new CompositeCloseable(closeAction, new SearcherCloser(searcher)));
    }

    @Override
    public void closeWhenDone() {
        this.helper.closeWhenDone();
    }

    @Override
    public boolean isClosed() {
        return this.helper.isClosed();
    }

    @Override
    public void open() {
        this.helper.open();
    }

    @Override
    public void close() {
        this.helper.close();
    }

    private static class SearcherCloser
    implements Closeable {
        private final IndexSearcher searcher;

        SearcherCloser(IndexSearcher searcher) {
            this.searcher = searcher;
            this.incReaderRef();
        }

        @Override
        public void close() {
            try {
                this.searcher.close();
                this.decReaderRef();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        private void incReaderRef() {
            this.searcher.getIndexReader().incRef();
            Counter searcherLuceneOpenInstrument = Instrumentation.pullCounter(InstrumentationName.SEARCHER_LUCENE_OPEN);
            searcherLuceneOpenInstrument.incrementAndGet();
        }

        private void decReaderRef() throws IOException {
            this.searcher.getIndexReader().decRef();
            Counter searcherLuceneCloseInstrument = Instrumentation.pullCounter(InstrumentationName.SEARCHER_LUCENE_CLOSE);
            searcherLuceneCloseInstrument.incrementAndGet();
        }
    }
}

