/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.event.IndexRecoveryEnabledEvent;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.index.ha.IndexSnapshotService;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexRecoveryService
implements IndexRecoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexRecoveryService.class);
    private final IndexRecoveryManager indexRecoveryManager;
    private final PermissionManager permissionManager;
    private final IndexPathManager indexPathManager;
    private final ServiceManager serviceManager;
    private final FileFactory fileFactory;
    private final EventPublisher eventPublisher;

    public DefaultIndexRecoveryService(IndexRecoveryManager indexRecoveryManager, PermissionManager permissionManager, IndexPathManager indexPathManager, ServiceManager serviceManager, FileFactory fileFactory, EventPublisher eventPublisher) {
        this.indexRecoveryManager = indexRecoveryManager;
        this.permissionManager = permissionManager;
        this.indexPathManager = indexPathManager;
        this.serviceManager = serviceManager;
        this.fileFactory = fileFactory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public IndexCommandResult recoverIndexFromBackup(ApplicationUser user, Context context, I18nHelper i18n, String recoveryFilename, TaskProgressSink taskProgressSink) throws IndexException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(44, user)) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.index.recovery.unauthorised"));
        }
        File recoveryFile = this.validateRecoveryFile(user, (ErrorCollection)errorCollection, i18n, recoveryFilename);
        if (errorCollection.hasAnyErrors()) {
            return new IndexCommandResult((ErrorCollection)errorCollection);
        }
        return this.indexRecoveryManager.recoverIndexFromBackup(recoveryFile, taskProgressSink);
    }

    private File validateRecoveryFile(ApplicationUser user, ErrorCollection errorCollection, I18nHelper i18n, String path) {
        if (StringUtils.isBlank((String)path)) {
            errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.specified"));
            return null;
        }
        File actualFile = this.fileFactory.getFile(path);
        if (!actualFile.exists()) {
            errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.found"));
        } else if (actualFile.isDirectory()) {
            errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.zip"));
        } else if (!actualFile.canRead()) {
            errorCollection.addError("indexPath", i18n.getText("admin.errors.path.entered.is.not.readable"));
        } else if (!this.validIndexZipFile(user, actualFile)) {
            errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.zip"));
        }
        return actualFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validIndexZipFile(ApplicationUser user, File zipFile) {
        String segmentFileName = "segments.gen";
        ArrayList<String> requiredEntries = new ArrayList<String>();
        int basePathLength = this.indexPathManager.getIndexRootPath().length();
        requiredEntries.add(this.indexPathManager.getIssueIndexPath().substring(basePathLength + 1) + "/" + "segments.gen");
        requiredEntries.add(this.indexPathManager.getCommentIndexPath().substring(basePathLength + 1) + "/" + "segments.gen");
        requiredEntries.add(this.indexPathManager.getChangeHistoryIndexPath().substring(basePathLength + 1) + "/" + "segments.gen");
        try {
            ZipFile file = new ZipFile(zipFile.getAbsolutePath());
            try {
                for (String entryName : requiredEntries) {
                    if (file.getEntry(entryName) != null) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                ZipFile.closeQuietly((ZipFile)file);
            }
        }
        catch (IOException e) {
            LOG.debug("Can't access zip file '" + zipFile.getPath() + "'");
            return false;
        }
    }

    public int size() {
        return this.indexRecoveryManager.size();
    }

    public boolean isEmpty() {
        return this.indexRecoveryManager.isEmpty();
    }

    @Override
    public void updateRecoverySettings(ApplicationUser user, boolean recoveryEnabled, String cronExpression) throws Exception {
        JiraServiceContainer service = this.serviceManager.getServiceWithName(IndexSnapshotService.getServiceName());
        if (this.permissionManager.hasPermission(44, user)) {
            if (recoveryEnabled) {
                if (service == null) {
                    this.serviceManager.addService(IndexSnapshotService.getServiceName(), IndexSnapshotService.class, cronExpression);
                } else {
                    this.serviceManager.editService(service.getId(), cronExpression, Collections.emptyMap());
                }
            } else if (service != null) {
                this.serviceManager.removeService(service.getId());
            }
            this.eventPublisher.publish((Object)new IndexRecoveryEnabledEvent(recoveryEnabled));
        }
    }

    @Override
    public boolean isRecoveryEnabled(ApplicationUser user) {
        try {
            return this.serviceManager.getServiceWithName(IndexSnapshotService.getServiceName()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getSnapshotCronExpression(ApplicationUser user) {
        try {
            JiraServiceContainer service = this.serviceManager.getServiceWithName(IndexSnapshotService.getServiceName());
            if (service != null) {
                return service.getCronExpression();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

