/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.index.request.ReindexComponent;
import com.atlassian.jira.index.request.ReindexRequestBase;
import com.atlassian.jira.index.request.ReindexRequestDao;
import com.atlassian.jira.index.request.ReindexStatus;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReindexRequestDaoImpl
implements ReindexRequestDao {
    private final EntityEngine entityEngine;

    public ReindexRequestDaoImpl(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    @Nonnull
    public List<ReindexRequestBase> getRequestsWithStatus(@Nonnull ReindexStatus status) {
        return Select.from(Entity.REINDEX_REQUEST).whereEqual("status", status.name()).orderBy("requestTime").runWith(this.entityEngine).asList();
    }

    @Override
    @Nonnull
    public ReindexRequestBase writeRequest(@Nonnull ReindexRequestBase request) {
        if (request.getId() == null) {
            return this.entityEngine.createValue(Entity.REINDEX_REQUEST, request);
        }
        this.entityEngine.updateValue(Entity.REINDEX_REQUEST, request);
        return request;
    }

    @Override
    @Nonnull
    public List<ReindexComponent> getComponentsForRequest(long requestId) {
        return Select.from(Entity.REINDEX_COMPONENT).whereEqual("requestId", requestId).orderBy("id").runWith(this.entityEngine).asList();
    }

    @Override
    @Nonnull
    public ReindexComponent writeComponent(@Nonnull ReindexComponent component) {
        return this.entityEngine.createValue(Entity.REINDEX_COMPONENT, component);
    }

    @Override
    public void removeComponents(long requestId) {
        Delete.from(Entity.REINDEX_COMPONENT).whereEqual("requestId", requestId).execute(this.entityEngine);
    }

    @Override
    @Nullable
    public ReindexRequestBase findRequestById(long requestId) {
        return (ReindexRequestBase)Select.from(Entity.REINDEX_REQUEST).whereEqual("id", requestId).runWith(this.entityEngine).singleValue();
    }

    @Override
    public void removeAllPendingRequests() {
        Delete.from(Entity.REINDEX_REQUEST).whereEqual("status", ReindexStatus.PENDING.name()).execute(this.entityEngine);
    }
}

