/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.settings;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;

public class IndexingLanguageSetting {
    private static final String REINDEX_NOTIFICATION_MSG_I18N_KEY = "admin.notifications.task.general.configuration.indexing.language";
    private final ApplicationProperties applicationProperties;
    private final ReindexMessageManager reindexMessageManager;

    public IndexingLanguageSetting(ApplicationProperties applicationProperties, ReindexMessageManager reindexMessageManager) {
        this.applicationProperties = applicationProperties;
        this.reindexMessageManager = reindexMessageManager;
    }

    public String getValue() {
        return this.applicationProperties.getString("jira.i18n.language.index");
    }

    public void setValueTo(ApplicationUser user, String indexingLanguage) {
        if (!this.getValue().equals(indexingLanguage)) {
            this.applicationProperties.setString("jira.i18n.language.index", indexingLanguage);
            this.reindexMessageManager.pushMessage(user, REINDEX_NOTIFICATION_MSG_I18N_KEY);
        }
    }
}

