/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.provider;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.attachment.FileSystemAttachmentStore;
import com.atlassian.jira.issue.attachment.RemoteAttachmentStore;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.store.DualSendingAttachmentStore;
import com.atlassian.jira.issue.attachment.store.provider.BlobStoreAttachmentStoreModeProvider;
import com.atlassian.jira.issue.attachment.store.provider.StreamAttachmentStoreProvider;
import com.atlassian.jira.issue.attachment.store.strategy.StoreOperationStrategy;
import com.atlassian.jira.issue.attachment.store.strategy.StoreOperationStrategyFactory;
import com.atlassian.jira.issue.attachment.store.strategy.get.AttachmentGetStrategiesFactory;
import com.atlassian.jira.issue.attachment.store.strategy.get.DualAttachmentGetStrategy;
import com.atlassian.jira.issue.attachment.store.strategy.move.BackgroundResendingMoveStrategy;
import com.atlassian.jira.issue.attachment.store.strategy.move.MoveTemporaryStrategiesFactory;
import com.atlassian.jira.issue.attachment.store.strategy.move.SingleStoreMoveStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAttachmentStoreProviderImpl
implements StreamAttachmentStoreProvider {
    private static final Logger log = LoggerFactory.getLogger(StreamAttachmentStoreProviderImpl.class);
    private final BlobStoreAttachmentStoreModeProvider blobStoreAttachmentStoreModeProvider;
    private final FileSystemAttachmentStore fileSystemAttachmentStore;
    private final RemoteAttachmentStore remoteAttachmentStore;
    private final MoveTemporaryStrategiesFactory moveTemporaryStrategiesFactory;
    private final AttachmentGetStrategiesFactory attachmentGetStrategiesFactory;
    private final StoreOperationStrategyFactory storeOperationStrategyFactory;

    public StreamAttachmentStoreProviderImpl(BlobStoreAttachmentStoreModeProvider blobStoreAttachmentStoreModeProvider, FileSystemAttachmentStore fileSystemAttachmentStore, RemoteAttachmentStore remoteAttachmentStore, MoveTemporaryStrategiesFactory moveTemporaryStrategiesFactory, AttachmentGetStrategiesFactory attachmentGetStrategiesFactory, StoreOperationStrategyFactory storeOperationStrategyFactory) {
        this.blobStoreAttachmentStoreModeProvider = blobStoreAttachmentStoreModeProvider;
        this.fileSystemAttachmentStore = fileSystemAttachmentStore;
        this.remoteAttachmentStore = remoteAttachmentStore;
        this.moveTemporaryStrategiesFactory = moveTemporaryStrategiesFactory;
        this.attachmentGetStrategiesFactory = attachmentGetStrategiesFactory;
        this.storeOperationStrategyFactory = storeOperationStrategyFactory;
    }

    @Override
    public StreamAttachmentStore getStreamAttachmentStore() {
        BlobStoreAttachmentStoreModeProvider.Mode mode = this.blobStoreAttachmentStoreModeProvider.mode();
        switch (mode) {
            case FS_ONLY: {
                return this.fileSystemAttachmentStore;
            }
            case FS_PRIMARY: {
                return this.createStoreForFileSystemPrimary();
            }
            case REMOTE_PRIMARY: {
                return this.createStoreForRemotePrimary();
            }
            case REMOTE_ONLY: {
                return this.remoteAttachmentStore;
            }
        }
        log.warn("Unknown attachmentStore mode: {}, default File System store will be used to store and retrieve attachments", (Object)mode);
        return this.fileSystemAttachmentStore;
    }

    private StreamAttachmentStore createStoreForFileSystemPrimary() {
        BackgroundResendingMoveStrategy backgroundResendingStrategy = this.moveTemporaryStrategiesFactory.createBackgroundResendingStrategy((StreamAttachmentStore)this.fileSystemAttachmentStore, (StreamAttachmentStore)this.remoteAttachmentStore);
        DualAttachmentGetStrategy dualAttachmentGetStrategy = this.attachmentGetStrategiesFactory.createDualGetAttachmentStrategy(this.fileSystemAttachmentStore, (StreamAttachmentStore)this.remoteAttachmentStore);
        StoreOperationStrategy operationStrategy = this.storeOperationStrategyFactory.createFailoverOperationStrategy((StreamAttachmentStore)this.fileSystemAttachmentStore, (StreamAttachmentStore)this.remoteAttachmentStore);
        return new DualSendingAttachmentStore((StreamAttachmentStore)this.fileSystemAttachmentStore, (StreamAttachmentStore)this.remoteAttachmentStore, dualAttachmentGetStrategy, backgroundResendingStrategy, operationStrategy);
    }

    private StreamAttachmentStore createStoreForRemotePrimary() {
        SingleStoreMoveStrategy moveSingleStrategy = this.moveTemporaryStrategiesFactory.createMoveOnlyPrimaryStrategy((StreamAttachmentStore)this.remoteAttachmentStore);
        DualAttachmentGetStrategy dualAttachmentGetStrategy = this.attachmentGetStrategiesFactory.createDualGetAttachmentStrategy(this.fileSystemAttachmentStore, (StreamAttachmentStore)this.remoteAttachmentStore);
        StoreOperationStrategy operationStrategy = this.storeOperationStrategyFactory.createFailoverOperationStrategy((StreamAttachmentStore)this.remoteAttachmentStore, (StreamAttachmentStore)this.fileSystemAttachmentStore);
        return new DualSendingAttachmentStore((StreamAttachmentStore)this.remoteAttachmentStore, (StreamAttachmentStore)this.fileSystemAttachmentStore, dualAttachmentGetStrategy, moveSingleStrategy, operationStrategy);
    }

    @Override
    public Option<FileSystemAttachmentStore> getFileSystemStore() {
        BlobStoreAttachmentStoreModeProvider.Mode mode = this.blobStoreAttachmentStoreModeProvider.mode();
        if (mode == BlobStoreAttachmentStoreModeProvider.Mode.FS_ONLY || mode == BlobStoreAttachmentStoreModeProvider.Mode.FS_PRIMARY) {
            return Option.some((Object)this.fileSystemAttachmentStore);
        }
        return Option.none();
    }
}

