/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory.metadata;

import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataMarshaller;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHistoryMetadataMarshaller
implements HistoryMetadataMarshaller {
    private static final Logger log = LoggerFactory.getLogger(JsonHistoryMetadataMarshaller.class);

    @Override
    @Nullable
    public HistoryMetadata unmarshall(@Nonnull String input) {
        try {
            return (HistoryMetadata)new ObjectMapper().readValue(input, HistoryMetadata.class);
        }
        catch (IOException e) {
            log.debug("Error unmarshalling HistoryMetadata object", (Throwable)e);
            return null;
        }
    }

    @Override
    public String marshall(@Nonnull HistoryMetadata historyMetadata) {
        try {
            return new ObjectMapper().writeValueAsString((Object)historyMetadata);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

