/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentComparator;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class CommentSearchManager {
    private final UserManager userManager;
    private final OfBizDelegator delegator;
    private final IssueManager issueManager;
    private final ProjectRoleManager projectRoleManager;
    private final CommentPermissionManager commentPermissionManager;
    private static final String COMMENT_ID = "id";

    public CommentSearchManager(UserManager userManager, OfBizDelegator delegator, IssueManager issueManager, ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager) {
        this.userManager = userManager;
        this.delegator = delegator;
        this.issueManager = issueManager;
        this.projectRoleManager = projectRoleManager;
        this.commentPermissionManager = commentPermissionManager;
    }

    public Comment convertToComment(GenericValue gv) {
        return this.convertToComment(gv, (Issue)this.issueManager.getIssueObject(gv.getLong("issue")));
    }

    public Comment getCommentById(Long commentId) {
        return this.getMutableComment(commentId);
    }

    public MutableComment getMutableComment(Long commentId) {
        if (commentId == null) {
            throw new IllegalArgumentException("The comment id must not be null.");
        }
        GenericValue gv = this.delegator.findById("Action", commentId);
        if (gv != null) {
            return this.convertToComment(gv, (Issue)this.issueManager.getIssueObject(gv.getLong("issue")));
        }
        return null;
    }

    public List<Comment> getComments(Issue issue) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        try {
            List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            for (Object allComment : allComments) {
                MutableComment comment = this.convertToComment((GenericValue)allComment, issue);
                comments.add((Comment)comment);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(comments, CommentComparator.COMPARATOR);
        return comments;
    }

    @Nonnull
    public List<Comment> getCommentsForUserSince(@Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Date since) {
        EntityFieldMap issueCommentsCondition = new EntityFieldMap((Map)FieldMap.build((String)"issue", (Object)issue.getId(), (String)"type", (Object)"comment"), EntityOperator.AND);
        EntityExpr dateCondition = new EntityExpr("updated", EntityOperator.GREATER_THAN, (Object)new Timestamp(since.getTime()));
        EntityConditionList finalCondition = new EntityConditionList(Arrays.asList(issueCommentsCondition, dateCondition), EntityOperator.AND);
        List commentsSinceDate = this.delegator.findByCondition("Action", (EntityCondition)finalCondition, null, (List)ImmutableList.of((Object)"updated DESC", (Object)"id ASC"));
        return this.getVisibleComments(issue, user, commentsSinceDate);
    }

    public List<Comment> getCommentsForUser(Issue issue, ApplicationUser user) {
        List<Comment> visibleComments;
        try {
            List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            visibleComments = this.getVisibleComments(issue, user, allComments);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(visibleComments, CommentComparator.COMPARATOR);
        return visibleComments;
    }

    private List<Comment> getVisibleComments(Issue issue, ApplicationUser user, List<GenericValue> commentValues) {
        ArrayList<Comment> visibleComments = new ArrayList<Comment>();
        for (GenericValue commentGV : commentValues) {
            MutableComment comment = this.convertToComment(commentGV, issue);
            if (!this.commentPermissionManager.hasBrowsePermission(user, (Comment)comment)) continue;
            visibleComments.add((Comment)comment);
        }
        return visibleComments;
    }

    private MutableComment convertToComment(GenericValue gv, Issue issue) {
        Timestamp createdTS = gv.getTimestamp("created");
        Timestamp updatedTS = gv.getTimestamp("updated");
        CommentImpl comment = new CommentImpl(this.projectRoleManager, this.userManager.getUserByKeyEvenWhenUnknown(gv.getString("author")), this.userManager.getUserByKeyEvenWhenUnknown(gv.getString("updateauthor")), gv.getString("body"), gv.getString("level"), gv.getLong("rolelevel"), JiraDateUtils.copyDateNullsafe((Date)createdTS), JiraDateUtils.copyDateNullsafe((Date)updatedTS), issue);
        comment.setId(gv.getLong(COMMENT_ID));
        return comment;
    }
}

