/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import java.util.Comparator;

public class IssueTypeKeyComparator
implements Comparator<String> {
    private final ConstantsManager constantsManager;

    public IssueTypeKeyComparator(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        IssueType issueType1 = this.constantsManager.getIssueTypeObject(o1);
        IssueType issueType2 = this.constantsManager.getIssueTypeObject(o2);
        Long sequence1 = issueType1.getSequence();
        Long sequence2 = issueType2.getSequence();
        if (sequence1 == null) {
            if (sequence2 == null) {
                return 0;
            }
            return -1;
        }
        if (sequence2 == null) {
            return 1;
        }
        return sequence1.compareTo(sequence2);
    }
}

