/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConfigContextPersisterWorker {
    public static final String ENTITY_TABLE_NAME = "ConfigurationContext";
    public static final String ENTITY_PROJECT = "project";
    public static final String ENTITY_KEY = "key";
    public static final String ENTITY_SCHEME_ID = "fieldconfigscheme";
    private final OfBizDelegator delegator;
    private final ProjectManager projectManager;
    private static final Logger log = LoggerFactory.getLogger(FieldConfigContextPersisterWorker.class);
    private final CachedReference<Multimap<Long, GenericValue>> configContextsBySchemeId;

    public FieldConfigContextPersisterWorker(OfBizDelegator delegator, ProjectManager projectManager, CacheManager cacheManager) {
        this.delegator = delegator;
        this.projectManager = projectManager;
        this.configContextsBySchemeId = cacheManager.getCachedReference(FieldConfigContextPersisterWorker.class, "configContextsBySchemeId", (Supplier)new ConfigContextCacheLoader());
    }

    public List<JiraContextNode> getAllContextsForConfigScheme(FieldConfigScheme fieldConfigScheme) {
        Iterable contextNodeGvs = Iterables.filter((Iterable)((Multimap)this.configContextsBySchemeId.get()).get((Object)fieldConfigScheme.getId()), (Predicate)new ProjectInConfigurationContextGenericValueExists());
        return CollectionUtil.transform((Iterable)contextNodeGvs, (Function)new Function<GenericValue, JiraContextNode>(){

            public JiraContextNode get(GenericValue input) {
                return FieldConfigContextPersisterWorker.this.transformToDomainObject(input);
            }
        });
    }

    public void removeContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId()));
        this.invalidateAll();
        if (log.isDebugEnabled()) {
            log.debug(result + " contexts deleted for field config scheme with id '" + fieldConfigScheme.getId() + "'");
        }
    }

    public void removeContextsForProject(Project project) {
        int result = this.delegator.removeByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_PROJECT, (Object)project.getId()));
        this.invalidateAll();
        if (log.isDebugEnabled()) {
            log.debug(result + " contexts deleted for " + project);
        }
    }

    public Object retrieve(JiraContextNode context, String key) {
        List result;
        if (context != null && (result = this.delegator.findByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(context).add((Object)ENTITY_KEY, (Object)key).toMap())) != null && !result.isEmpty()) {
            Long schemeId = ((GenericValue)result.iterator().next()).getLong(ENTITY_SCHEME_ID);
            if (result.size() > 1) {
                log.warn("More than one FieldConfigScheme returned for a given context. Database may be corrupted.Returning first Long: " + schemeId + ". Context: " + context + " with key: " + key + " returned " + result + ".");
            }
            return schemeId;
        }
        return null;
    }

    public void store(String fieldId, JiraContextNode contextNode, FieldConfigScheme fieldConfigScheme) {
        if (this.retrieve(contextNode, fieldId) != null) {
            this.remove(contextNode, fieldId);
        }
        if (fieldConfigScheme != null) {
            MapBuilder<String, Object> props = this.transformToFieldsMap(contextNode);
            props.add((Object)ENTITY_KEY, (Object)fieldId);
            props.add((Object)ENTITY_SCHEME_ID, (Object)fieldConfigScheme.getId());
            EntityUtils.createValue(ENTITY_TABLE_NAME, props.toMap());
        }
        this.invalidateAll();
    }

    public void remove(JiraContextNode context, String key) {
        if (context != null && key != null) {
            this.delegator.removeByAnd(ENTITY_TABLE_NAME, this.transformToFieldsMap(context).add((Object)ENTITY_KEY, (Object)key).toMap());
            this.invalidateAll();
        } else {
            log.warn("Context or key was null. Nothing was removed");
        }
    }

    void invalidateAll() {
        this.configContextsBySchemeId.reset();
    }

    private MapBuilder<String, Object> transformToFieldsMap(JiraContextNode contextNode) {
        return MapBuilder.newBuilder((Map)contextNode.appendToParamsMap(Collections.emptyMap()));
    }

    private JiraContextNode transformToDomainObject(GenericValue contextAsGv) {
        return new ProjectContext(contextAsGv.getLong(ENTITY_PROJECT), this.projectManager);
    }

    private class ConfigContextCacheLoader
    implements Supplier<Multimap<Long, GenericValue>> {
        private ConfigContextCacheLoader() {
        }

        public Multimap<Long, GenericValue> get() {
            List genericValues = FieldConfigContextPersisterWorker.this.delegator.findAll(FieldConfigContextPersisterWorker.ENTITY_TABLE_NAME);
            ArrayListMultimap cacheValues = ArrayListMultimap.create();
            for (GenericValue genericValue : genericValues) {
                cacheValues.put((Object)genericValue.getLong(FieldConfigContextPersisterWorker.ENTITY_SCHEME_ID), (Object)genericValue);
            }
            return cacheValues;
        }
    }

    private class ProjectInConfigurationContextGenericValueExists
    implements Predicate<GenericValue> {
        private ProjectInConfigurationContextGenericValueExists() {
        }

        public boolean apply(GenericValue contextAsGv) {
            Long projectId = contextAsGv.getLong(FieldConfigContextPersisterWorker.ENTITY_PROJECT);
            return projectId == null || FieldConfigContextPersisterWorker.this.projectManager.getProjectObj(projectId) != null;
        }
    }
}

