/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.manager.ImmutableSimpleOption;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.manager.OptionsService;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.option.SimpleOption;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultOptionsService
implements OptionsService {
    private final PermissionManager permissionManager;
    private final OptionsManager optionsManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public DefaultOptionsService(PermissionManager permissionManager, OptionsManager optionsManager, I18nHelper.BeanFactory i18nFactory) {
        this.permissionManager = permissionManager;
        this.optionsManager = optionsManager;
        this.i18nFactory = i18nFactory;
    }

    @Nonnull
    public ServiceOutcome<OptionsService.SetValidateResult> validateSetOptions(@Nonnull OptionsService.SetOptionParams param) {
        param.validate();
        I18nHelper i18nHelper = this.i18n(param.user());
        if (!this.permissionManager.hasPermission(0, param.user())) {
            return ServiceOutcomeImpl.error(i18nHelper.getText("admin.options.need.admin"), ErrorCollection.Reason.FORBIDDEN);
        }
        FieldConfig config = null;
        CustomField field = param.customField();
        if (field == null) {
            config = param.fieldConfig();
            field = config.getCustomField();
        }
        if (!DefaultOptionsService.hasOptions(field)) {
            return ServiceOutcomeImpl.error(i18nHelper.getText("admin.options.bad.field", field.getCustomFieldType().getName()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (config == null && (config = field.getRelevantConfig(param.issueContext())) == null) {
            return ServiceOutcomeImpl.error(i18nHelper.getText("admin.options.no.config"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        SimpleErrorCollection collection = new SimpleErrorCollection();
        if (!this.validate(i18nHelper, param.options(), (ErrorCollection)collection)) {
            return ServiceOutcomeImpl.from((ErrorCollection)collection, null);
        }
        return ServiceOutcomeImpl.ok(new SetValidateResultImpl(Iterables.transform((Iterable)param.options(), (Function)new Function<SimpleOption<?>, ImmutableSimpleOption>(){

            public ImmutableSimpleOption apply(SimpleOption<?> input) {
                return new ImmutableSimpleOption(input);
            }
        }), config, param.user()));
    }

    @Nonnull
    public ServiceOutcome<Options> setOptions(@Nonnull OptionsService.SetValidateResult validation) {
        if (!(validation instanceof SetValidateResultImpl)) {
            throw new IllegalArgumentException("Invalid validation result passed.");
        }
        SetValidateResultImpl serviceResult = (SetValidateResultImpl)validation;
        if (!this.permissionManager.hasPermission(0, serviceResult.caller)) {
            SimpleErrorCollection collection = new SimpleErrorCollection();
            collection.addErrorMessage(this.i18n(serviceResult.caller).getText("admin.options.need.admin"), ErrorCollection.Reason.FORBIDDEN);
            return ServiceOutcomeImpl.from((ErrorCollection)collection, null);
        }
        this.setOptions(serviceResult.config, serviceResult.options);
        return ServiceOutcomeImpl.ok(this.optionsManager.getOptions(serviceResult.config));
    }

    private void setOptions(FieldConfig config, Iterable<? extends SimpleOption<?>> options) {
        this.optionsManager.removeCustomFieldConfigOptions(config);
        this.setOptions(config, options, null);
    }

    private void setOptions(FieldConfig config, Iterable<? extends SimpleOption<?>> options, Long parentId) {
        int pos = 0;
        for (SimpleOption<?> option : options) {
            Option newOption = this.optionsManager.createOption(config, parentId, Long.valueOf(pos++), option.getValue());
            this.setOptions(config, option.getChildOptions(), newOption.getOptionId());
        }
    }

    private boolean validate(I18nHelper i18n, Iterable<? extends SimpleOption<?>> options, ErrorCollection collection) {
        boolean result = true;
        TreeSet names = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (SimpleOption<?> option : options) {
            String value = StringUtils.stripToNull((String)option.getValue());
            if (value == null) {
                collection.addErrorMessage(i18n.getText("admin.options.empty.name"), ErrorCollection.Reason.VALIDATION_FAILED);
                result = false;
            } else if (!names.add(value)) {
                collection.addErrorMessage(i18n.getText("admin.options.duplicate.name", option.getValue()), ErrorCollection.Reason.VALIDATION_FAILED);
                result = false;
            } else if (value.length() > 255) {
                collection.addErrorMessage(i18n.getText("admin.options.too.long", option.getValue()), ErrorCollection.Reason.VALIDATION_FAILED);
                result = false;
            }
            result = this.validate(i18n, option.getChildOptions(), collection) && result;
        }
        return result;
    }

    private I18nHelper i18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    private static boolean hasOptions(CustomField field) {
        return Iterables.any((Iterable)field.getConfigurationItemTypes(), (Predicate)Predicates.instanceOf(SettableOptionsConfigItem.class));
    }

    static class SetValidateResultImpl
    implements OptionsService.SetValidateResult {
        private final List<? extends SimpleOption<?>> options;
        private final FieldConfig config;
        private final ApplicationUser caller;

        SetValidateResultImpl(Iterable<? extends SimpleOption<?>> options, FieldConfig config, ApplicationUser caller) {
            this.config = config;
            this.caller = caller;
            this.options = ImmutableList.copyOf(options);
        }

        ApplicationUser getCaller() {
            return this.caller;
        }

        FieldConfig getConfig() {
            return this.config;
        }

        List<? extends SimpleOption<?>> getOptions() {
            return this.options;
        }
    }
}

