/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.VersionPickerCustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.VersionPickerCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.VersionCustomFieldIndexer;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.CustomFieldVersionStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.CustomFieldClauseContextFactory;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.context.IntersectingClauseContextFactory;
import com.atlassian.jira.jql.context.VersionClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.VersionCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.VersionCustomFieldValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.VersionClauseValuesGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class VersionPickerSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final VersionManager versionManager;
    private final VersionResolver versionResolver;
    private final JqlOperandResolver operandResolver;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final ClauseContextFactory versionClauseContextFactory;
    private final PermissionManager permissionManager;
    private final ContextSetUtil contextSetUtil;
    private final FieldConfigSchemeClauseContextUtil clauseContextUtil;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final I18nHelper.BeanFactory beanFactory = ComponentAccessor.getI18nHelperFactory();
    private ProjectManager projectManager;
    private VelocityRequestContextFactory velocityRequestContextFactory;
    private ApplicationProperties applicationProperties;
    private VelocityTemplatingEngine templatingEngine;

    public VersionPickerSearcher(VersionManager versionManager, FieldVisibilityManager fieldVisibilityManager, VersionResolver versionResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, VersionClauseContextFactory versionClauseContextFactory, PermissionManager permissionManager, ContextSetUtil contextSetUtil, FieldConfigSchemeClauseContextUtil clauseContextUtil, CustomFieldInputHelper customFieldInputHelper, ProjectManager projectManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine) {
        this.clauseContextUtil = (FieldConfigSchemeClauseContextUtil)Assertions.notNull((String)"clauseContextUtil", (Object)clauseContextUtil);
        this.contextSetUtil = (ContextSetUtil)Assertions.notNull((String)"contextSetUtil", (Object)contextSetUtil);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.versionClauseContextFactory = versionClauseContextFactory;
        this.versionManager = (VersionManager)Assertions.notNull((String)"versionManager", (Object)versionManager);
        this.versionResolver = (VersionResolver)Assertions.notNull((String)"versionResolver", (Object)versionResolver);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.fieldVisibilityManager = (FieldVisibilityManager)Assertions.notNull((String)"fieldVisibilityManager", (Object)fieldVisibilityManager);
        this.fieldFlagOperandRegistry = (FieldFlagOperandRegistry)Assertions.notNull((String)"fieldFlagOperandRegistry", (Object)fieldFlagOperandRegistry);
        this.customFieldInputHelper = (CustomFieldInputHelper)Assertions.notNull((String)"customFieldInputHelper", (Object)customFieldInputHelper);
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"velocityRequestContextFactory", (Object)velocityRequestContextFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.templatingEngine = (VelocityTemplatingEngine)Assertions.notNull((String)"templatingEngine", (Object)templatingEngine);
    }

    public void init(CustomField field) {
        VersionCustomFieldIndexer indexer = new VersionCustomFieldIndexer(this.fieldVisibilityManager, field);
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new VersionPickerCustomFieldRenderer(field, this.projectManager, this.versionManager, this.fieldVisibilityManager, this.velocityRequestContextFactory, this.applicationProperties, this.templatingEngine, this.permissionManager, this.searcherInformation.getNameKey());
        this.searchInputTransformer = new VersionPickerCustomFieldSearchInputTransformer(field, this.operandResolver, this.fieldFlagOperandRegistry, this.versionResolver, this.customFieldInputHelper);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldContextValueGeneratingClauseHandler((ClauseValidator)new VersionCustomFieldValidator(this.versionResolver, this.operandResolver, this.permissionManager, this.versionManager, this.beanFactory), (ClauseQueryFactory)new VersionCustomFieldClauseQueryFactory(field.getId(), this.versionResolver, this.operandResolver), (ClauseContextFactory)new IntersectingClauseContextFactory(this.contextSetUtil, (Collection)CollectionBuilder.newBuilder((Object[])new ClauseContextFactory[]{new CustomFieldClauseContextFactory(field, this.clauseContextUtil, ContextSetUtil.getInstance()), this.versionClauseContextFactory}).asList()), (ClauseValuesGenerator)new VersionClauseValuesGenerator(this.versionManager, this.permissionManager, this.beanFactory), OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, JiraDataTypes.VERSION);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return new CustomFieldVersionStatisticsMapper(customField, this.versionManager, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper, false);
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldVersionStatisticsMapper(customField, this.versionManager, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper, false);
    }
}

