/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersisterImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.map.CacheObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class CachedFieldConfigSchemePersister
extends FieldConfigSchemePersisterImpl {
    private final FieldConfigManager fieldConfigManager;
    private final Cache<Long, CacheObject<FieldConfigScheme>> cacheById;
    private final Cache<String, CacheObject<List<FieldConfigScheme>>> cacheByCustomField;
    private final Cache<Long, FieldConfigScheme> cacheByFieldConfig;

    public CachedFieldConfigSchemePersister(OfBizDelegator delegator, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, FieldConfigContextPersister fieldContextPersister, CacheManager cacheManager, FieldConfigManager fieldConfigManager, CacheManager ca) {
        super(delegator, constantsManager, fieldConfigPersister, fieldContextPersister, cacheManager);
        this.fieldConfigManager = fieldConfigManager;
        this.cacheById = cacheManager.getCache(CachedFieldConfigSchemePersister.class.getName() + ".cacheById", (CacheLoader)new FiledConfigByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheByCustomField = cacheManager.getCache(CachedFieldConfigSchemePersister.class.getName() + ".cacheByCustomField", (CacheLoader)new FieldConfigSchemeByFieldCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheByFieldConfig = cacheManager.getCache(CachedFieldConfigSchemePersister.class.getName() + ".cacheByFieldConfig", (CacheLoader)new FieldConfigSchemeBySchemeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @Override
    public void init() {
        super.init();
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.invalidateAll();
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @Override
    @Nullable
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId == null) {
            return null;
        }
        return (FieldConfigScheme)((CacheObject)this.cacheById.get((Object)configSchemeId)).getValue();
    }

    @Override
    @Nullable
    public List<FieldConfigScheme> getConfigSchemesForCustomField(ConfigurableField field) {
        if (field == null) {
            return null;
        }
        return (List)((CacheObject)this.cacheByCustomField.get((Object)field.getId())).getValue();
    }

    @Override
    @Nullable
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        if (fieldConfig == null) {
            return null;
        }
        return (FieldConfigScheme)this.cacheByFieldConfig.get((Object)fieldConfig.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldConfigScheme update(FieldConfigScheme configScheme) {
        FieldConfigScheme fieldConfigScheme = null;
        try {
            fieldConfigScheme = super.update(configScheme);
        }
        finally {
            if (fieldConfigScheme != null) {
                this.cacheById.remove((Object)fieldConfigScheme.getId());
                ConfigurableField field = fieldConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove((Object)field.getId());
                }
                Map configs = fieldConfigScheme.getConfigs();
                for (FieldConfig config : configs.values()) {
                    this.cacheByFieldConfig.remove((Object)config.getId());
                }
            }
        }
        return fieldConfigScheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRelatedConfigsForUpdate(@Nonnull FieldConfigScheme configScheme, @Nonnull GenericValue gv) throws GenericEntityException {
        try {
            super.removeRelatedConfigsForUpdate(configScheme, gv);
        }
        finally {
            Map configs = configScheme.getConfigs();
            for (FieldConfig config : configs.values()) {
                this.cacheByFieldConfig.remove((Object)config.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Long fieldConfigSchemeId) {
        FieldConfigScheme fieldConfigScheme = null;
        try {
            fieldConfigScheme = super.removeIfExist(fieldConfigSchemeId);
        }
        finally {
            this.cacheById.remove((Object)fieldConfigSchemeId);
            if (fieldConfigScheme != null) {
                ConfigurableField field = fieldConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove((Object)field.getId());
                }
                Map configs = fieldConfigScheme.getConfigs();
                for (FieldConfig config : configs.values()) {
                    this.cacheByFieldConfig.remove((Object)config.getId());
                }
            }
        }
    }

    private class FieldConfigSchemeBySchemeCacheLoader
    implements CacheLoader<Long, FieldConfigScheme> {
        private FieldConfigSchemeBySchemeCacheLoader() {
        }

        public FieldConfigScheme load(@Nonnull Long configId) {
            FieldConfig fieldConfig = CachedFieldConfigSchemePersister.this.fieldConfigManager.getFieldConfig(configId);
            return CachedFieldConfigSchemePersister.super.getConfigSchemeForFieldConfig(fieldConfig);
        }
    }

    private class FieldConfigSchemeByFieldCacheLoader
    implements CacheLoader<String, CacheObject<List<FieldConfigScheme>>> {
        private FieldConfigSchemeByFieldCacheLoader() {
        }

        public CacheObject<List<FieldConfigScheme>> load(@Nonnull String fieldId) {
            ConfigurableField field = (ConfigurableField)ComponentAccessor.getFieldManager().getField(fieldId);
            List schemes = CollectionUtil.copyAsImmutableList((Collection)CachedFieldConfigSchemePersister.super.getConfigSchemesForCustomField(field));
            return CacheObject.wrap(schemes);
        }
    }

    private class FiledConfigByIdCacheLoader
    implements CacheLoader<Long, CacheObject<FieldConfigScheme>> {
        private FiledConfigByIdCacheLoader() {
        }

        public CacheObject<FieldConfigScheme> load(@Nonnull Long configSchemeId) {
            FieldConfigScheme scheme = CachedFieldConfigSchemePersister.super.getFieldConfigScheme(configSchemeId);
            return CacheObject.wrap(scheme);
        }
    }
}

