/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class FieldLayoutImpl
extends AbstractGVBean
implements FieldLayout {
    private Long id;
    private String name;
    private String description;
    private List<FieldLayoutItem> fieldLayoutItems;
    protected Map<String, FieldLayoutItem> fieldLayoutItemByFieldId;
    private String type;

    public FieldLayoutImpl(GenericValue genericValue, List<FieldLayoutItem> fieldLayoutItems) {
        this.setFieldLayoutItems(fieldLayoutItems);
        this.setGenericValue(genericValue);
        this.init();
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            this.description = this.getGenericValue().getString("description");
            this.type = this.getGenericValue().getString("type");
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDefault() {
        return "default".equals(this.getType());
    }

    protected void setId(Long id) {
        this.id = id;
    }

    protected void setInternalName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    protected void setInternalDescription(String description) {
        this.description = description;
        this.updateGV("description", description);
    }

    public List<FieldLayoutItem> getFieldLayoutItems() {
        return Collections.unmodifiableList(this.getInternalList());
    }

    public FieldLayoutItem getFieldLayoutItem(OrderableField orderableField) {
        if (orderableField == null) {
            throw new IllegalArgumentException("OrderableField cannot be null.");
        }
        return this.getFieldLayoutItem(orderableField.getId());
    }

    public FieldLayoutItem getFieldLayoutItem(String fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("FieldId cannot be null.");
        }
        return this.fieldLayoutItemByFieldId.get(fieldId);
    }

    public List<FieldLayoutItem> getVisibleLayoutItems(Project project, List<String> issueTypes) {
        List<FieldLayoutItem> visibleList = this.findLayout(true, project, issueTypes, new Function<FieldLayoutItem, FieldLayoutItem>(){

            public FieldLayoutItem get(FieldLayoutItem input) {
                return input;
            }
        });
        this.orderLayoutItemsForProcessing(visibleList);
        return Collections.unmodifiableList(visibleList);
    }

    public List<FieldLayoutItem> getVisibleLayoutItems(ApplicationUser remoteUser, Project project, List<String> issueTypes) {
        return this.getVisibleLayoutItems(project, issueTypes);
    }

    private void orderLayoutItemsForProcessing(List<FieldLayoutItem> fieldLayoutItems) {
        Iterator<FieldLayoutItem> iterator = fieldLayoutItems.iterator();
        while (iterator.hasNext()) {
            FieldLayoutItem fieldLayoutItem = iterator.next();
            if (!"assignee".equals(fieldLayoutItem.getOrderableField().getId())) continue;
            iterator.remove();
            fieldLayoutItems.add(fieldLayoutItem);
            break;
        }
    }

    public List<FieldLayoutItem> getVisibleCustomFieldLayoutItems(Project project, List<String> issueTypes) {
        ArrayList<FieldLayoutItem> visibleCustomFieldList = new ArrayList<FieldLayoutItem>();
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            CustomField customField;
            if (!this.getFieldManager().isCustomField((Field)fieldLayoutItem.getOrderableField()) || fieldLayoutItem.isHidden() || !(customField = (CustomField)fieldLayoutItem.getOrderableField()).isInScope(project, issueTypes)) continue;
            visibleCustomFieldList.add(fieldLayoutItem);
        }
        return visibleCustomFieldList;
    }

    public List<Field> getHiddenFields(Project project, List<String> issueTypeIds) {
        List<Field> result = this.findLayout(false, project, issueTypeIds, new Function<FieldLayoutItem, Field>(){

            public Field get(FieldLayoutItem input) {
                return input.getOrderableField();
            }
        });
        result.addAll(this.getFieldManager().getUnavailableFields());
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> findLayout(boolean notHidden, Project project, List<String> issueTypeIds, Function<FieldLayoutItem, T> func) {
        FieldManager fieldManager = this.getFieldManager();
        LinkedList<Object> result = new LinkedList<Object>();
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            if (!fieldManager.isCustomField((Field)fieldLayoutItem.getOrderableField())) {
                if (!(fieldLayoutItem.isHidden() ^ notHidden)) continue;
                result.add(func.get((Object)fieldLayoutItem));
                continue;
            }
            CustomField customField = (CustomField)fieldLayoutItem.getOrderableField();
            if (notHidden) {
                if (fieldLayoutItem.isHidden() || !customField.isInScope(project, issueTypeIds)) continue;
                result.add(func.get((Object)fieldLayoutItem));
                continue;
            }
            if (!fieldLayoutItem.isHidden() && customField.isInScope(project, issueTypeIds)) continue;
            result.add(func.get((Object)fieldLayoutItem));
        }
        return result;
    }

    protected FieldManager getFieldManager() {
        return ComponentAccessor.getFieldManager();
    }

    protected HackyFieldRendererRegistry getHackyFieldRendererRegistry() {
        return (HackyFieldRendererRegistry)ComponentAccessor.getComponentOfType(HackyFieldRendererRegistry.class);
    }

    public List<FieldLayoutItem> getRequiredFieldLayoutItems(Project project, List<String> issueTypes) {
        ArrayList<FieldLayoutItem> result = new ArrayList<FieldLayoutItem>();
        for (FieldLayoutItem fieldLayoutItem : this.getInternalList()) {
            if (!fieldLayoutItem.isRequired()) continue;
            if (this.getFieldManager().isCustomField((Field)fieldLayoutItem.getOrderableField())) {
                CustomField customField = this.getFieldManager().getCustomField(fieldLayoutItem.getOrderableField().getId());
                if (!customField.isInScope(project, issueTypes)) continue;
                result.add(fieldLayoutItem);
                continue;
            }
            result.add(fieldLayoutItem);
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isFieldHidden(String fieldId) {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(fieldId);
        if (fieldLayoutItem == null) {
            return this.getFieldManager().isOrderableField(fieldId);
        }
        return fieldLayoutItem.isHidden();
    }

    public String getRendererTypeForField(String fieldId) {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(fieldId);
        if (fieldLayoutItem != null) {
            return fieldLayoutItem.getRendererType();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof FieldLayout && Objects.equal((Object)this.id, (Object)((FieldLayout)o).getId());
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    protected List<FieldLayoutItem> getInternalList() {
        return this.fieldLayoutItems;
    }

    void setFieldLayoutItems(List<FieldLayoutItem> fieldLayoutItems) {
        this.fieldLayoutItems = fieldLayoutItems;
        if (fieldLayoutItems == null) {
            this.fieldLayoutItemByFieldId = null;
            return;
        }
        this.fieldLayoutItemByFieldId = new HashMap<String, FieldLayoutItem>(fieldLayoutItems.size());
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            this.fieldLayoutItemByFieldId.put(fieldLayoutItem.getOrderableField().getId(), fieldLayoutItem);
        }
    }
}

