/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingMode;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class LuceneIssueIndexProvider
implements Iterable<Index.Manager> {
    private final AtomicReference<Map<IndexDirectoryFactory.Name, Index.Manager>> ref = new AtomicReference();
    private final IndexDirectoryFactory factory;

    public LuceneIssueIndexProvider(@Nonnull IndexDirectoryFactory factory) {
        this.factory = (IndexDirectoryFactory)Assertions.notNull((String)"factory", (Object)factory);
    }

    @Override
    public Iterator<Index.Manager> iterator() {
        return this.open().values().iterator();
    }

    void close() {
        Map indexes = this.ref.getAndSet(null);
        if (indexes == null) {
            return;
        }
        for (Index.Manager manager : indexes.values()) {
            manager.close();
        }
    }

    Map<IndexDirectoryFactory.Name, Index.Manager> open() {
        Map<IndexDirectoryFactory.Name, Index.Manager> result = this.ref.get();
        while (result == null) {
            this.ref.compareAndSet(null, (Map<IndexDirectoryFactory.Name, Index.Manager>)this.factory.get());
            result = this.ref.get();
        }
        return result;
    }

    public Index getIssueIndex() {
        return this.get(IndexDirectoryFactory.Name.ISSUE).getIndex();
    }

    public Index getCommentIndex() {
        return this.get(IndexDirectoryFactory.Name.COMMENT).getIndex();
    }

    public Index getChangeHistoryIndex() {
        return this.get(IndexDirectoryFactory.Name.CHANGE_HISTORY).getIndex();
    }

    public Index getWorklogIndex() {
        return this.get(IndexDirectoryFactory.Name.WORKLOG).getIndex();
    }

    public Index getIndex(IndexDirectoryFactory.Name indexName) {
        return this.get(indexName).getIndex();
    }

    public Index.Manager get(IndexDirectoryFactory.Name key) {
        return this.open().get((Object)key);
    }

    List<String> getIndexPaths() {
        return this.factory.getIndexPaths();
    }

    String getIndexRootPath() {
        return this.factory.getIndexRootPath();
    }

    void setMode(IndexingMode type) {
        this.factory.setIndexingMode(type);
    }
}

