/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.LabelsIndexer;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.LabelsSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.LabelsSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.LabelIndexInfoResolver;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;

public class LabelsSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public LabelsSearcher(VelocityTemplatingEngine templatingEngine, VelocityRequestContextFactory contextFactory, FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        SimpleFieldSearchConstantsWithEmpty constants = SystemSearchConstants.forLabels();
        this.searcherInformation = new GenericSearcherInformation(constants.getSearcherId(), "common.filters.labels", Collections.singletonList(LabelsIndexer.class), this.fieldReference, SearcherGroupType.ISSUE);
        this.searchRenderer = new LabelsSearchRenderer(constants, contextFactory, fieldVisibilityManager, applicationProperties, templatingEngine, this.searcherInformation.getNameKey());
        this.searchInputTransformer = new LabelsSearchInputTransformer(new LabelIndexInfoResolver(false), operandResolver, fieldFlagOperandRegistry);
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

