/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.GroupTextOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractProjectConstantsRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.OptionWithValidity;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.VersionsOptions;
import com.atlassian.jira.issue.search.searchers.transformer.VersionSearchInput;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVersionRenderer
extends AbstractProjectConstantsRenderer<VersionSearchInput, VersionsOptions>
implements SearchRenderer {
    private static final Logger log = LoggerFactory.getLogger(AbstractVersionRenderer.class);
    private static final Function<Version, OptionWithValidity> VERSION_TO_OPTION = new Function<Version, OptionWithValidity>(){

        public OptionWithValidity get(Version version) {
            return new OptionWithValidity(AbstractProjectConstantsRenderer.createId(version.getName()), version.getName());
        }
    };
    private static final Function<VersionSearchInput, String> INPUT_OPTION_VALUE = new Function<VersionSearchInput, String>(){

        public String get(VersionSearchInput input) {
            if (input.isVersion()) {
                return AbstractProjectConstantsRenderer.createId(input.getValue());
            }
            if (input.isNoVersion()) {
                return "-1";
            }
            if (input.isAllUnreleased()) {
                return "-2";
            }
            if (input.isAllReleased()) {
                return "-3";
            }
            throw new IllegalArgumentException("Invalid input");
        }
    };
    private final VersionManager versionManager;
    private final boolean unreleasedOptionsFirst;
    private final FieldVisibilityManager fieldVisibilityManager;

    protected AbstractVersionRenderer(SimpleFieldSearchConstantsWithEmpty constants, String searcherNameKey, ProjectManager projectManager, VersionManager versionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, PermissionManager permissionManager, boolean unreleasedOptionsFirst) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, fieldVisibilityManager, constants, projectManager, searcherNameKey, permissionManager);
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.versionManager = versionManager;
        this.unreleasedOptionsFirst = unreleasedOptionsFirst;
    }

    @Override
    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        boolean hasOptions = this.hasAnyValidOption(user, searchContext);
        return hasOptions && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.searchConstants.getFieldId(), searchContext, user);
    }

    protected boolean hasAnyValidOption(ApplicationUser searcher, SearchContext searchContext) {
        List projectIds = searchContext.getProjectIds();
        if (CollectionUtils.isEmpty((Collection)projectIds)) {
            Collection<Project> visibleProjects = this.getVisibleProjects(searcher);
            for (Project visibleProject : visibleProjects) {
                if (this.versionManager.getVersions(visibleProject.getId(), false).isEmpty()) continue;
                return true;
            }
        } else {
            for (Long projectId : projectIds) {
                if (this.isValidProject(projectId, searcher)) {
                    if (this.versionManager.getVersions(projectId, false).isEmpty()) continue;
                    return true;
                }
                log.warn("Project for search context " + searchContext + " is invalid");
            }
        }
        return false;
    }

    @Override
    VersionsOptions getValidOptions(ApplicationUser searcher, SearchContext searchContext) {
        VersionsOptions options = new VersionsOptions();
        List projectIds = searchContext.getProjectIds();
        if (CollectionUtils.isEmpty((Collection)projectIds)) {
            TreeSet allVersionOptions = Sets.newTreeSet((Comparator)new OptionComparator());
            Collection<Project> visibleProjects = this.getVisibleProjects(searcher);
            if (CollectionUtils.isNotEmpty(visibleProjects)) {
                allVersionOptions.addAll(CollectionUtil.transform((Iterable)this.versionManager.getAllVersionsForProjects(visibleProjects, false), VERSION_TO_OPTION));
            }
            if (!allVersionOptions.isEmpty()) {
                options.released(new GroupTextOption("", "", Lists.newArrayList((Iterable)allVersionOptions)));
            }
        } else if (projectIds.size() == 1) {
            Long projectId = (Long)projectIds.iterator().next();
            if (this.isValidProject(projectId, searcher)) {
                Collection releasedVersions;
                Collection unreleasedVersions = this.versionManager.getVersionsUnreleased(projectId, false);
                if (!unreleasedVersions.isEmpty()) {
                    TreeSet unreleasedVersionOptions = Sets.newTreeSet((Comparator)new OptionComparator());
                    unreleasedVersionOptions.addAll(CollectionUtil.transform((Iterable)unreleasedVersions, VERSION_TO_OPTION));
                    options.unreleased(new GroupTextOption("-2", this.getI18n(searcher).getText("common.filters.unreleasedversions"), Lists.newArrayList((Iterable)unreleasedVersionOptions)));
                    options.allUnreleased((Option)new OptionWithValidity("-2", this.getI18n(searcher).getText("common.filters.unreleasedversions")));
                }
                if (!(releasedVersions = this.versionManager.getVersionsReleasedDesc(projectId, false)).isEmpty()) {
                    TreeSet releasedVersionOptions = Sets.newTreeSet((Comparator)new OptionComparator());
                    releasedVersionOptions.addAll(CollectionUtil.transform((Iterable)releasedVersions, VERSION_TO_OPTION));
                    options.released(new GroupTextOption("-3", this.getI18n(searcher).getText("common.filters.releasedversions"), Lists.newArrayList((Iterable)releasedVersionOptions)));
                    options.allReleased((Option)new OptionWithValidity("-3", this.getI18n(searcher).getText("common.filters.releasedversions")));
                }
            } else {
                log.warn("Project for search context " + searchContext + " is invalid");
            }
        } else {
            TreeSet allVersionOptions = Sets.newTreeSet((Comparator)new OptionComparator());
            for (Long projectId : projectIds) {
                if (this.isValidProject(projectId, searcher)) {
                    allVersionOptions.addAll(CollectionUtil.transform((Iterable)this.versionManager.getVersions(projectId, false), VERSION_TO_OPTION));
                    continue;
                }
                log.warn("Project for search context " + searchContext + " is invalid");
            }
            if (!allVersionOptions.isEmpty()) {
                options.released(new GroupTextOption("", "", Lists.newArrayList((Iterable)allVersionOptions)));
            }
        }
        return options;
    }

    @Override
    Function<VersionSearchInput, String> inputValueToOptionIdFunction() {
        return INPUT_OPTION_VALUE;
    }

    @Override
    OptionWithValidity createBlankOption(ApplicationUser searcher) {
        return new OptionWithValidity("-1", this.getI18n(searcher).getText("common.filters.noversion"));
    }

    @Override
    void createGroups(List<GroupTextOption> groups, VersionsOptions options, Set<Option> invalidOptions) {
        if (this.unreleasedOptionsFirst) {
            this.addOption(groups, "", options.getNo(), options.getAllUnreleased(), options.getAllReleased());
            this.addOption(groups, "invalid", invalidOptions);
            this.addOption(groups, options.getUnreleased());
            this.addOption(groups, options.getReleased());
        } else {
            this.addOption(groups, "", options.getNo(), options.getAllReleased(), options.getAllUnreleased());
            this.addOption(groups, "invalid", invalidOptions);
            this.addOption(groups, options.getReleased());
            this.addOption(groups, options.getUnreleased());
        }
    }

    @Override
    String nameFromSelectedValue(ApplicationUser searcher, VersionSearchInput searchInput) {
        if (searchInput.isNoVersion()) {
            return this.getI18n(searcher).getText("common.filters.noversion");
        }
        if (searchInput.isAllUnreleased()) {
            return this.getI18n(searcher).getText("common.filters.unreleasedversions");
        }
        if (searchInput.isAllReleased()) {
            return this.getI18n(searcher).getText("common.filters.releasedversions");
        }
        return searchInput.getValue();
    }

    @Override
    Collection<AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> getSelectedLabels(ApplicationUser searcher, Collection<VersionSearchInput> selectedValues) {
        return this.getSelectedObjects(selectedValues, new VersionLabelFunction(searcher));
    }

    class VersionLabelFunction
    implements Function<VersionSearchInput, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> {
        private final ApplicationUser searcher;

        VersionLabelFunction(ApplicationUser searcher) {
            this.searcher = searcher;
        }

        public AbstractProjectConstantsRenderer.GenericProjectConstantsLabel get(VersionSearchInput input) {
            if (input.isNoVersion()) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(AbstractVersionRenderer.this.getI18n(this.searcher).getText("common.filters.noversion"));
            }
            if (input.isAllUnreleased()) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(AbstractVersionRenderer.this.getI18n(this.searcher).getText("common.filters.unreleasedversions"));
            }
            if (input.isAllReleased()) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(AbstractVersionRenderer.this.getI18n(this.searcher).getText("common.filters.releasedversions"));
            }
            return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(input.getValue());
        }
    }

    private static class OptionComparator
    implements Comparator<Option> {
        private OptionComparator() {
        }

        @Override
        public int compare(Option option1, Option option2) {
            return option1.getName().compareToIgnoreCase(option2.getName());
        }
    }
}

