/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.util.AbstractTransformIssueIterator;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class IssueIdsIssueIterable
implements IssuesIterable {
    private final Collection<Long> ids;
    private final IssueManager issueManager;

    public IssueIdsIssueIterable(Collection<Long> issueIds, IssueManager issueManager) {
        this.ids = Collections.unmodifiableCollection(new ArrayList((Collection)Assertions.notNull((String)"issueIds", issueIds)));
        this.issueManager = (IssueManager)Assertions.notNull((String)"issueManager", (Object)issueManager);
    }

    public void foreach(Consumer<Issue> sink) {
        CollectionUtil.foreach((Iterator)new AbstractTransformIssueIterator<Long>(this.ids){

            @Override
            protected Issue transform(Long o) {
                return IssueIdsIssueIterable.this.issueManager.getIssueObject(o);
            }
        }, sink);
    }

    public int size() {
        return this.ids.size();
    }

    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.size() + " items): " + this.ids;
    }
}

