/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.watchers;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueWatcherAddedEvent;
import com.atlassian.jira.event.issue.IssueWatcherDeletedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatcherManager
implements WatcherManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWatcherManager.class);
    private static final String CACHE_KEY = DefaultWatcherManager.class.getName() + ".watchers";
    public static final String ASSOCIATION_TYPE = "WatchIssue";
    private final UserAssociationStore userAssociationStore;
    private final ApplicationProperties applicationProperties;
    private final IssueIndexManager indexManager;
    private final IssueFactory issueFactory;
    private final EventPublisher eventPublisher;
    private final IssueManager issueManager;
    private final UserManager userManager;

    public DefaultWatcherManager(UserAssociationStore userAssociationStore, ApplicationProperties applicationProperties, IssueIndexManager indexManager, IssueFactory issueFactory, EventPublisher eventPublisher, IssueManager issueManager, UserManager userManager) {
        this.userAssociationStore = userAssociationStore;
        this.applicationProperties = applicationProperties;
        this.indexManager = indexManager;
        this.issueFactory = issueFactory;
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
        this.userManager = userManager;
    }

    @Nonnull
    public Issue startWatching(@Nonnull ApplicationUser user, @Nonnull Issue issue) {
        return (Issue)Iterables.getOnlyElement(this.startWatching(user, (Collection<Issue>)ImmutableList.of((Object)issue), Contexts.nullContext()));
    }

    @Nonnull
    public Collection<Issue> startWatching(@Nonnull ApplicationUser user, @Nonnull Collection<Issue> issues, @Nonnull Context taskContext) {
        ArrayList updatedIssues = Lists.newArrayListWithCapacity((int)issues.size());
        for (Issue issue : issues) {
            Context.Task task = taskContext.start((Object)issue);
            updatedIssues.add(this.updateWatch(true, user, issue));
            task.complete();
        }
        this.reindex(updatedIssues);
        return updatedIssues;
    }

    @Nonnull
    public Issue stopWatching(@Nonnull ApplicationUser user, @Nonnull Issue issue) {
        return (Issue)Iterables.getOnlyElement(this.stopWatching(user, (Collection<Issue>)ImmutableList.of((Object)issue), Contexts.nullContext()));
    }

    @Nonnull
    public Collection<Issue> stopWatching(@Nonnull ApplicationUser user, @Nonnull Collection<Issue> issues, @Nonnull Context taskContext) {
        ArrayList<Issue> updatedIssues = new ArrayList<Issue>(issues.size());
        for (Issue issue : issues) {
            Context.Task task = taskContext.start((Object)issue);
            updatedIssues.add(this.updateWatch(false, user, issue));
            task.complete();
        }
        this.reindex(updatedIssues);
        return updatedIssues;
    }

    public List<String> getCurrentWatcherUsernames(@Nonnull Issue issue) throws DataAccessException {
        Collection<String> watcherKeys = this.getWatcherUserKeys(issue);
        return (List)watcherKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKeyEvenWhenUnknown(arg_0)).filter(user -> user != null).map(ApplicationUser::getUsername).collect(CollectorsUtil.toNewArrayListWithSizeOf(watcherKeys));
    }

    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    public boolean isWatching(@Nullable ApplicationUser user, @Nonnull Issue issue) {
        if (user == null) {
            return false;
        }
        Long watches = issue.getWatches();
        return watches != null && watches != 0L && ((ImmutableSet)this.getWatchersCache().getUnchecked((Object)issue.getId())).contains((Object)user.getKey());
    }

    public boolean isWatching(ApplicationUser user, GenericValue issue) {
        return this.isWatching(user, (Issue)this.issueFactory.getIssue(issue));
    }

    public List<ApplicationUser> getWatchers(@Nonnull Issue issue, @Nonnull Locale userLocale) {
        Collection<String> watcherKeys = this.getWatcherUserKeys(issue);
        return (List)watcherKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKeyEvenWhenUnknown(arg_0)).filter(user -> user != null).sorted((Comparator<ApplicationUser>)new ApplicationUserBestNameComparator(userLocale)).collect(CollectorsUtil.toNewArrayListWithSizeOf(watcherKeys));
    }

    public int getWatcherCount(@Nonnull Issue issue) {
        return this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, issue.getId()).size();
    }

    public Collection<String> getWatcherUserKeys(@Nonnull Issue issue) {
        return (Collection)this.getWatchersCache().getUnchecked((Object)issue.getId());
    }

    private Issue updateWatch(boolean addWatch, @Nullable ApplicationUser user, Issue issue) {
        if (this.validateUpdate(user)) {
            try {
                if (addWatch) {
                    if (!this.isWatching(user, issue)) {
                        this.getWatchersCache().invalidate((Object)issue.getId());
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        Issue updatedIssue = this.adjustWatchCount(issue, 1);
                        this.eventPublisher.publish((Object)new IssueWatcherAddedEvent(updatedIssue, user));
                        return updatedIssue;
                    }
                } else if (this.isWatching(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user, issue);
                    this.getWatchersCache().invalidate((Object)issue.getId());
                    Issue updatedIssue = this.adjustWatchCount(issue, -1);
                    this.eventPublisher.publish((Object)new IssueWatcherDeletedEvent(updatedIssue, user));
                    return updatedIssue;
                }
            }
            catch (GenericEntityException e) {
                log.error("Error changing watch association", (Throwable)e);
                return issue;
            }
        }
        return issue;
    }

    private boolean validateUpdate(@Nullable ApplicationUser user) {
        if (user == null) {
            log.error("You must specify a user.");
            return false;
        }
        return true;
    }

    private Issue adjustWatchCount(Issue originalIssue, int adjustValue) throws GenericEntityException {
        long watches = this.recalculateWatches(originalIssue, adjustValue);
        Long issueId = originalIssue.getId();
        GenericValue clonedIssue = (GenericValue)originalIssue.getGenericValue().clone();
        clonedIssue.clear();
        clonedIssue.set("id", (Object)issueId);
        clonedIssue.set("watches", (Object)watches);
        clonedIssue.store();
        return this.issueManager.getIssueObject(issueId);
    }

    private long recalculateWatches(Issue issue, int adjustValue) {
        Long watches = issue.getWatches();
        if (watches == null) {
            watches = 0L;
        }
        if ((watches = Long.valueOf(watches + (long)adjustValue)) < 0L) {
            watches = 0L;
        }
        return watches;
    }

    public void removeAllWatchesForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"User", (Object)user);
        List<GenericValue> watchedIssues = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        this.userAssociationStore.removeUserAssociationsFromUser(ASSOCIATION_TYPE, user, "Issue");
        this.getWatchersCache().invalidateAll();
        this.reindex(watchedIssues.stream().map(arg_0 -> ((IssueFactory)this.issueFactory).getIssue(arg_0)).map(issue -> {
            this.eventPublisher.publish((Object)new IssueWatcherDeletedEvent((Issue)issue, user));
            return issue;
        }).collect(Collectors.toList()));
    }

    private void reindex(Collection<Issue> issues) {
        try {
            this.indexManager.reIndexIssueObjects(issues, IssueIndexingParams.INDEX_ISSUE_ONLY);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    protected LoadingCache<Long, ImmutableSet<String>> getWatchersCache() {
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from(issueId -> ImmutableSet.copyOf(this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, (Long)issueId))));
        if (ExecutingHttpRequest.get() != null) {
            return (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(CACHE_KEY, () -> cache);
        }
        return cache;
    }
}

