/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Set;

public class TimeTrackingPermissionChecker
implements ClausePermissionChecker {
    private final ApplicationProperties applicationProperties;
    private final ClausePermissionChecker permissionChecker;

    public TimeTrackingPermissionChecker(FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory, ApplicationProperties applicationProperties) {
        this.permissionChecker = fieldClausePermissionHandlerFactory.createPermissionChecker("timetracking");
        this.applicationProperties = applicationProperties;
    }

    public boolean hasPermissionToUseClause(ApplicationUser user) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.permissionChecker.hasPermissionToUseClause(user);
    }

    public boolean hasPermissionToUseClause(ApplicationUser searcher, Set<FieldLayout> fieldLayouts) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.permissionChecker.hasPermissionToUseClause(searcher, fieldLayouts);
    }
}

