/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.fugue.Option;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ActualValueEqualityQueryFactory;
import com.atlassian.jira.jql.query.ActualValueRelationalQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.DateEqualityQueryFactory;
import com.atlassian.jira.jql.query.DateRelationalQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.LikeQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.NumberIndexValueConverter;
import com.atlassian.jira.jql.util.SimpleIndexValueConverter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractPropertyClauseQueryFactory
implements ClauseQueryFactory {
    private final DoubleConverter doubleConverter;
    private final JqlDateSupport jqlDateSupport;
    private final JqlOperandResolver operandResolver;
    private final JiraAuthenticationContext authenticationContext;

    protected AbstractPropertyClauseQueryFactory(DoubleConverter doubleConverter, JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, JiraAuthenticationContext authenticationContext) {
        this.doubleConverter = doubleConverter;
        this.jqlDateSupport = jqlDateSupport;
        this.operandResolver = operandResolver;
        this.authenticationContext = authenticationContext;
    }

    @Nonnull
    public QueryFactoryResult getQuery(@Nonnull QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        Option<Property> property = this.getProperty(terminalClause);
        if (property.isDefined() && this.isSupportedOperator(terminalClause)) {
            return this.getLuceneQuery((Property)property.get(), terminalClause);
        }
        return QueryFactoryResult.createFalseResult();
    }

    protected abstract boolean isSupportedOperator(TerminalClause var1);

    protected abstract Option<Property> getProperty(TerminalClause var1);

    protected abstract Iterable<IndexDocumentConfiguration.Type> getPropertyTypes(Property var1);

    private QueryFactoryResult getLuceneQuery(Property property, TerminalClause terminalClause) {
        Iterable<IndexDocumentConfiguration.Type> propertyTypes = this.getPropertyTypes(property);
        Iterable<OperatorSpecificQueryFactory> queryFactories = this.getQueryFactories(propertyTypes);
        String fieldName = AbstractPropertyClauseQueryFactory.getLuceneFieldName(property);
        return new GenericClauseQueryFactory(fieldName, (List)Lists.newArrayList(queryFactories), this.operandResolver).getQuery((QueryCreationContext)new QueryCreationContextImpl(this.authenticationContext.getUser()), terminalClause);
    }

    public static String getLuceneFieldName(Property property) {
        return "ISSUEPROP_" + property.getAsPropertyString();
    }

    private Iterable<OperatorSpecificQueryFactory> getQueryFactories(Iterable<IndexDocumentConfiguration.Type> types) {
        return Iterables.concat((Iterable)Iterables.transform(types, (Function)new Function<IndexDocumentConfiguration.Type, Iterable<OperatorSpecificQueryFactory>>(){

            public Iterable<OperatorSpecificQueryFactory> apply(IndexDocumentConfiguration.Type type) {
                ImmutableList.Builder builder = ImmutableList.builder();
                switch (type) {
                    case NUMBER: {
                        NumberIndexValueConverter valueConverter = new NumberIndexValueConverter(AbstractPropertyClauseQueryFactory.this.doubleConverter);
                        builder.add((Object)new ActualValueEqualityQueryFactory((IndexValueConverter)valueConverter));
                        builder.add((Object)new ActualValueRelationalQueryFactory((IndexValueConverter)valueConverter));
                        break;
                    }
                    case TEXT: {
                        builder.add((Object)new LikeQueryFactory());
                        break;
                    }
                    case DATE: {
                        builder.add((Object)new DateEqualityQueryFactory(AbstractPropertyClauseQueryFactory.this.jqlDateSupport));
                        builder.add((Object)new DateRelationalQueryFactory(AbstractPropertyClauseQueryFactory.this.jqlDateSupport));
                        break;
                    }
                    case STRING: {
                        builder.add((Object)new ActualValueEqualityQueryFactory((IndexValueConverter)new SimpleIndexValueConverter(false)));
                    }
                }
                return builder.build();
            }
        }));
    }
}

