/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.OpenBitSet;

public class IssueIdCollector
extends Collector {
    private static final int SMALL_COLLECT_RATIO = 10000;
    final int maxDocs;
    private int docBase;
    final OpenBitSet docIds;
    private final IndexReader indexReader;
    private int hitCount = 0;
    private int minDocId = Integer.MAX_VALUE;
    private int maxDocId = 0;

    public IssueIdCollector(IndexReader indexReader) {
        this.indexReader = indexReader;
        this.maxDocs = indexReader.maxDoc();
        this.docIds = new OpenBitSet((long)this.maxDocs);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int doc) throws IOException {
        int index = this.docBase + doc;
        this.docIds.fastSet(index);
        ++this.hitCount;
        this.minDocId = Math.min(this.minDocId, index);
        this.maxDocId = Math.max(this.maxDocId, index);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public Set<String> getIssueIds() throws IOException {
        int smallDocLimit = Math.max(50, this.maxDocs / 10000);
        if (this.hitCount == 0) {
            return ImmutableSet.of();
        }
        if (this.hitCount <= smallDocLimit) {
            return this.getIssueIdsDirectly();
        }
        return this.getIssueIdsByTerms();
    }

    private Set<String> getIssueIdsDirectly() throws IOException {
        TreeSet<String> issueIds = new TreeSet<String>();
        FieldSelector selector = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                return fieldName.equals("issue_id") ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };
        this.docIds.setNumWords(OpenBitSet.bits2words((long)(this.maxDocId + 1)));
        int docId = this.docIds.nextSetBit(this.minDocId);
        while (docId >= 0) {
            Document doc = this.indexReader.document(docId, selector);
            issueIds.add(doc.get("issue_id"));
            docId = this.docIds.nextSetBit(docId + 1);
        }
        return issueIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getIssueIdsByTerms() throws IOException {
        TreeSet<String> issueIds = new TreeSet<String>();
        TermDocs termDocs = this.indexReader.termDocs();
        TermEnum termEnum = this.indexReader.terms(new Term("issue_id", ""));
        try {
            Term term;
            while ((term = termEnum.term()) != null) {
                if (term.field() != "issue_id") {
                } else {
                    String issueId = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        int doc = termDocs.doc();
                        if (!this.docIds.get(doc)) continue;
                        issueIds.add(issueId);
                        break;
                    }
                    if (termEnum.next()) continue;
                }
                break;
            }
        }
        finally {
            termDocs.close();
            termEnum.close();
        }
        return issueIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllIssueIds() throws IOException {
        TreeSet<String> issueIds = new TreeSet<String>();
        try (TermEnum termEnum = this.indexReader.terms(new Term("issue_id", ""));){
            Term term;
            while ((term = termEnum.term()) != null) {
                if (term.field() != "issue_id") {
                } else {
                    String issueId = term.text();
                    issueIds.add(issueId);
                    if (termEnum.next()) continue;
                }
                break;
            }
        }
        return issueIds;
    }
}

