/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;

@InjectableComponent
public class ProjectCategoryResolver {
    private final ProjectManager projectManager;

    public ProjectCategoryResolver(ProjectManager projectManager) {
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
    }

    public ProjectCategory getProjectCategory(QueryLiteral literal) {
        Assertions.notNull((String)"literal", (Object)literal);
        if (literal.getStringValue() != null) {
            return this.getProjectCategoryForString(literal.getStringValue());
        }
        if (literal.getLongValue() != null) {
            return this.getProjectCategoryForLong(literal.getLongValue());
        }
        return null;
    }

    public Collection<Project> getProjectsForCategory(QueryLiteral literal) {
        Assertions.notNull((String)"literal", (Object)literal);
        if (literal.isEmpty()) {
            return this.projectManager.getProjectObjectsWithNoCategory();
        }
        ProjectCategory category = this.getProjectCategory(literal);
        return category != null ? this.projectManager.getProjectsFromProjectCategory(category) : Collections.emptySet();
    }

    private ProjectCategory getProjectCategoryForString(String rawValue) {
        Long valueAsLong;
        ProjectCategory category = this.getProjectCategoryByName(rawValue);
        if (category == null && (valueAsLong = this.getValueAsLong(rawValue)) != null) {
            category = this.getProjectCategoryById(valueAsLong);
        }
        return category;
    }

    private ProjectCategory getProjectCategoryForLong(Long longValue) {
        ProjectCategory category = this.getProjectCategoryById(longValue);
        if (category == null) {
            category = this.getProjectCategoryByName(longValue.toString());
        }
        return category;
    }

    private ProjectCategory getProjectCategoryByName(String rawValue) {
        return this.projectManager.getProjectCategoryObjectByNameIgnoreCase(rawValue);
    }

    private ProjectCategory getProjectCategoryById(Long rawValue) {
        return this.projectManager.getProjectCategoryObject(rawValue);
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

