/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.comparator.LocaleSensitiveStringComparator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractIssueConstantValuesGenerator
implements ClauseValuesGenerator {
    private static final Function<IssueConstant, String> constantToNameFunction = new Function<IssueConstant, String>(){

        public String get(IssueConstant input) {
            return input.getName();
        }
    };

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        List<String> constantNames = this.getAllConstantNames();
        Collections.sort(constantNames, new LocaleSensitiveStringComparator(this.getLocale(searcher)));
        ArrayList suggestions = Lists.newArrayListWithCapacity((int)constantNames.size());
        for (String constantName : constantNames) {
            if (suggestions.size() == maxNumResults) break;
            String lowerCaseConstName = constantName.toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseConstName.startsWith(valuePrefix.toLowerCase())) continue;
            suggestions.add(new ClauseValuesGenerator.Result(constantName));
        }
        return new ClauseValuesGenerator.Results((List)suggestions);
    }

    Locale getLocale(ApplicationUser searcher) {
        return new I18nBean(searcher).getLocale();
    }

    protected abstract List<IssueConstant> getAllConstants();

    protected List<String> getAllConstantNames() {
        return new ArrayList<String>(CollectionUtil.transform(this.getAllConstants().iterator(), constantToNameFunction));
    }
}

