/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.jql.values.AbstractIssueConstantValuesGenerator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolutionClauseValuesGenerator
extends AbstractIssueConstantValuesGenerator {
    private static final Pattern UNRESOLVED_PATTERN = Pattern.compile("['\"]*unresolved['\"]*", 2);
    private final ConstantsManager constantsManager;
    private static final Function<IssueConstant, String> resolutionToNameFunction = new Function<IssueConstant, String>(){

        public String get(IssueConstant input) {
            return ResolutionClauseValuesGenerator.quoteName(input.getName());
        }
    };

    public ResolutionClauseValuesGenerator(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @Override
    protected List<String> getAllConstantNames() {
        ArrayList<String> constantNames = new ArrayList<String>(CollectionUtil.transform(this.getAllConstants().iterator(), resolutionToNameFunction));
        constantNames.add("Unresolved");
        return constantNames;
    }

    @Override
    protected List<IssueConstant> getAllConstants() {
        return new ArrayList<IssueConstant>(this.constantsManager.getResolutionObjects());
    }

    static String quoteName(String name) {
        Matcher m = UNRESOLVED_PATTERN.matcher(name);
        if (m.find()) {
            return "\"" + name + "\"";
        }
        return name;
    }
}

