/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.UndefinedApplicationRoleName;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.DefaultLicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultLicensedApplications
implements LicensedApplications {
    private static final Logger log = LoggerFactory.getLogger(DefaultLicensedApplications.class);
    public static final String APPLICATION_NAMESPACE = ".product.";
    public static final String JIRA_PRODUCT_NAMESPACE = Product.JIRA.getNamespace() + ".product.";
    private static final Pattern APPLICATION_ROLE = Pattern.compile(Pattern.quote(JIRA_PRODUCT_NAMESPACE) + "(.+?)" + Pattern.quote(".") + "NumberOfUsers");
    private static final String PRODUCT_SUFFIX = ".active";
    private static final String JIRA_PRODUCT_ACTIVE = Product.JIRA.getNamespace() + ".active";
    private static final String JIRA_USER_LIMIT = Product.JIRA.getNamespace() + "." + "NumberOfUsers";
    private final boolean hasNativeRole;
    private final ImmutableMap<ApplicationKey, Integer> userLimitByApplication;
    private final Properties licenseProperties;

    public DefaultLicensedApplications(@Nonnull String license, @Nonnull LicenseDecoder licenseDecoder) throws LicenseException {
        this.licenseProperties = licenseDecoder.decode(license);
        ImmutableMap<ApplicationKey, Integer> applicationRoles = DefaultLicensedApplications.extractApplicationsFrom(this.licenseProperties);
        if (!applicationRoles.isEmpty()) {
            this.hasNativeRole = true;
            this.userLimitByApplication = applicationRoles;
        } else {
            this.hasNativeRole = false;
            this.userLimitByApplication = DefaultLicensedApplications.interpretAsApplicationLicense(this.licenseProperties);
        }
    }

    @Nonnull
    public Set<ApplicationKey> getKeys() {
        return this.userLimitByApplication.keySet();
    }

    public int getUserLimit(@Nonnull ApplicationKey key) {
        Integer numUsers = (Integer)this.userLimitByApplication.get((Object)key);
        return numUsers != null ? numUsers : 0;
    }

    @Nonnull
    public String getDescription() {
        Set<ApplicationKey> applications = this.getKeys();
        ArrayList<String> descriptions = new ArrayList<String>(applications.size());
        for (ApplicationKey appId : applications) {
            descriptions.add(this.getApplicationName(appId));
        }
        return Joiner.on((String)", ").join(descriptions);
    }

    private String getApplicationName(ApplicationKey appId) {
        ApplicationRoleDefinitions roleDefinitions = (ApplicationRoleDefinitions)ComponentAccessor.getComponent(ApplicationRoleDefinitions.class);
        Option<ApplicationRoleDefinitions.ApplicationRoleDefinition> role = roleDefinitions.getDefined(appId);
        if (role.isDefined()) {
            return ((ApplicationRoleDefinitions.ApplicationRoleDefinition)role.get()).name();
        }
        String name = this.licenseProperties.getProperty(DefaultLicensedApplications.getApplicationLicensePropertyName(appId, "Description"));
        if (!StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return UndefinedApplicationRoleName.of(appId).getName();
    }

    @Nonnull
    public static final String getApplicationLicensePropertyName(@Nonnull ApplicationKey app, @Nonnull String property) {
        return JIRA_PRODUCT_NAMESPACE + app.value() + "." + property;
    }

    @Nonnull
    static ImmutableMap<ApplicationKey, Integer> extractApplicationsFrom(@Nonnull Properties licenseProperties) throws LicenseException {
        HashMap<ApplicationKey, Integer> userLimitByApplication = new HashMap<ApplicationKey, Integer>();
        for (String propertyName : licenseProperties.stringPropertyNames()) {
            Matcher m = APPLICATION_ROLE.matcher(propertyName);
            if (!m.matches()) continue;
            String applicationKeyStr = m.group(1);
            if (!ApplicationKey.isValid((String)applicationKeyStr)) {
                throw new LicenseException(String.format("Application '%s' is declared but not a valid application.", applicationKeyStr));
            }
            ApplicationKey applicationKey = ApplicationKey.valueOf((String)m.group(1));
            if (!DefaultLicensedApplications.isApplicationActivated(applicationKey, licenseProperties)) {
                log.debug("Application '{}' is declared but not activated.", (Object)applicationKey);
                continue;
            }
            String userLimitStr = licenseProperties.getProperty(propertyName, "0");
            int userLimit = DefaultLicensedApplications.toUserLimit(userLimitStr, applicationKey);
            userLimitByApplication.put(applicationKey, userLimit);
        }
        return ImmutableMap.copyOf(userLimitByApplication);
    }

    private static ImmutableMap<ApplicationKey, Integer> interpretAsApplicationLicense(Properties licenseProperties) {
        HashMap<ApplicationKey, Integer> userLimitByApplication = new HashMap<ApplicationKey, Integer>();
        if (DefaultLicenseDetails.ENABLED.equals(licenseProperties.getProperty(JIRA_PRODUCT_ACTIVE, "false"))) {
            String jiraNumUsers = licenseProperties.getProperty(JIRA_USER_LIMIT, null);
            if (jiraNumUsers == null) {
                jiraNumUsers = licenseProperties.getProperty("NumberOfUsers", "0");
            }
            int userLimit = DefaultLicensedApplications.toUserLimit(jiraNumUsers, ApplicationKeys.SOFTWARE);
            userLimitByApplication.put(ApplicationKeys.SOFTWARE, userLimit);
        }
        if (DefaultLicenseDetails.ENABLED.equals(licenseProperties.getProperty("com.atlassian.servicedesk.active"))) {
            String jiraUsers = licenseProperties.getProperty("com.atlassian.servicedesk.numRoleCount");
            if (jiraUsers == null) {
                jiraUsers = licenseProperties.getProperty("NumberOfUsers");
            }
            userLimitByApplication.put(ApplicationKeys.SERVICE_DESK, DefaultLicensedApplications.toUserLimit(jiraUsers, ApplicationKeys.SERVICE_DESK));
        }
        return ImmutableMap.copyOf(userLimitByApplication);
    }

    private static int toUserLimit(String userLimitStr, ApplicationKey applicationKey) {
        int userLimit;
        try {
            userLimit = Integer.parseInt(userLimitStr);
            if (userLimit < 0) {
                userLimit = -1;
            }
        }
        catch (NumberFormatException ex) {
            String message = String.format("Invalid user count in license with role '%s': %s", userLimitStr, applicationKey);
            log.error(message);
            throw new LicenseException(message);
        }
        log.debug("License provides {} seats for '{}'", (Object)userLimit, (Object)applicationKey);
        return userLimit;
    }

    static boolean isApplicationActivated(@Nonnull ApplicationKey applicationKey, @Nonnull Properties licenseProperties) {
        return DefaultLicenseDetails.ENABLED.equals(licenseProperties.getProperty(JIRA_PRODUCT_NAMESPACE + applicationKey.value() + PRODUCT_SUFFIX, "false"));
    }

    public boolean hasNativeRole() {
        return this.hasNativeRole;
    }
}

