/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.annotations.Internal;
import com.atlassian.extras.api.Contact;
import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.Organisation;
import com.atlassian.extras.api.Partner;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;

@Internal
public final class JiraProductLicense
implements JiraLicense {
    private final JiraLicense jiraLicense;
    private final LicensedApplications licensedApplications;

    JiraProductLicense(LicensedApplications licensedApplications, JiraLicense jiraLicense) {
        this.jiraLicense = (JiraLicense)Assertions.notNull((String)"jiraLicense", (Object)jiraLicense);
        this.licensedApplications = (LicensedApplications)Assertions.notNull((String)"licensedApplications", (Object)licensedApplications);
    }

    @Nonnull
    public LicensedApplications getApplications() {
        return this.licensedApplications;
    }

    public int getLicenseVersion() {
        return this.jiraLicense.getLicenseVersion();
    }

    public String getDescription() {
        return this.jiraLicense.getDescription();
    }

    public Product getProduct() {
        return this.jiraLicense.getProduct();
    }

    public Iterable<Product> getProducts() {
        return this.jiraLicense.getProducts();
    }

    public String getServerId() {
        return this.jiraLicense.getServerId();
    }

    public Partner getPartner() {
        return this.jiraLicense.getPartner();
    }

    public Organisation getOrganisation() {
        return this.jiraLicense.getOrganisation();
    }

    public Collection<Contact> getContacts() {
        return this.jiraLicense.getContacts();
    }

    public Date getCreationDate() {
        return this.jiraLicense.getCreationDate();
    }

    public Date getPurchaseDate() {
        return this.jiraLicense.getPurchaseDate();
    }

    public Date getExpiryDate() {
        return this.jiraLicense.getExpiryDate();
    }

    public int getNumberOfDaysBeforeExpiry() {
        return this.jiraLicense.getNumberOfDaysBeforeExpiry();
    }

    public boolean isExpired() {
        return this.jiraLicense.isExpired();
    }

    public Date getGracePeriodEndDate() {
        return this.jiraLicense.getGracePeriodEndDate();
    }

    public int getNumberOfDaysBeforeGracePeriodExpiry() {
        return this.jiraLicense.getNumberOfDaysBeforeGracePeriodExpiry();
    }

    public boolean isWithinGracePeriod() {
        return this.jiraLicense.isWithinGracePeriod();
    }

    public boolean isGracePeriodExpired() {
        return this.jiraLicense.isGracePeriodExpired();
    }

    public String getSupportEntitlementNumber() {
        return this.jiraLicense.getSupportEntitlementNumber();
    }

    public Date getMaintenanceExpiryDate() {
        return this.jiraLicense.getMaintenanceExpiryDate();
    }

    public int getNumberOfDaysBeforeMaintenanceExpiry() {
        return this.jiraLicense.getNumberOfDaysBeforeMaintenanceExpiry();
    }

    public boolean isMaintenanceExpired() {
        return this.jiraLicense.isMaintenanceExpired();
    }

    public int getMaximumNumberOfUsers() {
        return this.jiraLicense.getMaximumNumberOfUsers();
    }

    public boolean isUnlimitedNumberOfUsers() {
        return this.jiraLicense.isUnlimitedNumberOfUsers();
    }

    public boolean isEvaluation() {
        return this.jiraLicense.isEvaluation();
    }

    public boolean isSubscription() {
        return this.jiraLicense.isSubscription();
    }

    public LicenseType getLicenseType() {
        return this.jiraLicense.getLicenseType();
    }

    public String getProperty(String s) {
        return this.jiraLicense.getProperty(s);
    }

    public LicenseEdition getLicenseEdition() {
        return this.jiraLicense.getLicenseEdition();
    }
}

