/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.mail.MailImageInliner;
import com.atlassian.jira.mail.util.MailAttachmentsManagerImpl;
import com.atlassian.jira.user.util.UserManager;
import javax.annotation.Nonnull;
import javax.mail.BodyPart;

public class MailImageInlinerImpl
implements MailImageInliner {
    private final AvatarService avatarService;
    private final AvatarTranscoder avatarTranscoder;
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final ApplicationProperties applicationProperties;

    public MailImageInlinerImpl(ApplicationProperties applicationProperties, AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, AvatarManager avatarManager) {
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.avatarTranscoder = avatarTranscoder;
        this.userManager = userManager;
        this.avatarManager = avatarManager;
    }

    @Nonnull
    public MailImageInliner.InlinedEmailBody inlineImages(@Nonnull String html) {
        MailAttachmentsManagerImpl mailAttachmentsManager = new MailAttachmentsManagerImpl(this.avatarService, this.avatarTranscoder, this.userManager, this.avatarManager, this.applicationProperties);
        String updatedHtml = mailAttachmentsManager.inlineImages(html);
        Iterable<BodyPart> bodyParts = mailAttachmentsManager.buildAttachmentsBodyParts();
        return new MailImageInliner.InlinedEmailBody(updatedHtml, bodyParts);
    }
}

