/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.notification.type.ApplicationUserToRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllWatchers
extends AbstractNotificationType {
    private static final Logger log = LoggerFactory.getLogger(AllWatchers.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueManager issueManager;

    public AllWatchers(JiraAuthenticationContext jiraAuthenticationContext, IssueManager issueManager) {
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)jiraAuthenticationContext);
        this.issueManager = (IssueManager)Assertions.notNull((Object)issueManager);
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        try {
            List watchers = this.getFromEventParams(event);
            if (watchers == null) {
                watchers = this.issueManager.getWatchersFor(event.getIssue());
            }
            return Lists.transform(watchers, (Function)ApplicationUserToRecipient.INSTANCE);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<ApplicationUser> getFromEventParams(IssueEvent event) {
        return (List)event.getParams().get(IssueEvent.WATCHERS_PARAM_NAME);
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.all.watchers");
    }
}

