/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.CloseableIterator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.ofbiz.core.entity.GenericValue;

class DatabaseIterator<E>
implements CloseableIterator<E> {
    private final Resolver<GenericValue, E> resolver;
    private final OfBizListIterator listIterator;
    private final AtomicMarkableReference<E> next = new AtomicMarkableReference<Object>(null, false);

    public DatabaseIterator(Resolver<GenericValue, E> resolver, OfBizListIterator listIterator) {
        Assertions.notNull((String)"resolver", resolver);
        Assertions.notNull((String)"listIterator", (Object)listIterator);
        this.resolver = resolver;
        this.listIterator = listIterator;
    }

    @Override
    public boolean hasNext() {
        this.populateNextIfNull();
        boolean[] finished = new boolean[1];
        E ref = this.next.get(finished);
        boolean hasNext = ref != null || !finished[0];
        return hasNext;
    }

    @Override
    public E next() {
        this.populateNextIfNull();
        if (this.next.isMarked()) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.next.getReference();
            return e;
        }
        finally {
            this.next.set(null, false);
        }
    }

    private void pullNext() {
        GenericValue gv = this.listIterator.next();
        Object ref = gv == null ? null : this.resolver.get((Object)gv);
        this.next.set(ref, ref == null);
    }

    private void populateNextIfNull() {
        if (!this.next.isMarked() && this.next.getReference() == null) {
            this.pullNext();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove an from this Iterator");
    }

    @Override
    public void close() {
        this.listIterator.close();
    }
}

