/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.customfield;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptors;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldTypeModuleDescriptorsImpl
implements CustomFieldTypeModuleDescriptors {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldTypeModuleDescriptorsImpl.class);
    private PluginAccessor pluginAccessor;

    public CustomFieldTypeModuleDescriptorsImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public List<CustomFieldType<?, ?>> getCustomFieldTypes() {
        List types = this.pluginAccessor.getEnabledModulesByClass(CustomFieldType.class);
        ArrayList field = Lists.newArrayListWithExpectedSize((int)types.size());
        for (Object type : types) {
            field.add((CustomFieldType)type);
        }
        Collections.sort(field, this.byName());
        return field;
    }

    private Comparator<? super CustomFieldType<?, ?>> byName() {
        return new Comparator<CustomFieldType<?, ?>>(){
            private final Ordering<String> ordering = Ordering.natural().nullsFirst();

            @Override
            public int compare(CustomFieldType<?, ?> o1, CustomFieldType<?, ?> o2) {
                return this.ordering.compare((Object)o1.getName(), (Object)o2.getName());
            }
        };
    }

    public Option<CustomFieldType> getCustomFieldType(String completeModuleKey) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(completeModuleKey);
        if (module != null && module instanceof CustomFieldTypeModuleDescriptor) {
            return Option.some((Object)((CustomFieldType)module.getModule()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Could not load custom field type plugin with key '" + completeModuleKey + "'. Is the plugin present and enabled?");
        }
        return Option.none();
    }
}

