/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;

public class MembersOfFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_MEMBERSOF = "membersOf";
    private static final int EXPECTED_ARGS = 1;
    private final UserUtil userUtil;
    private final CrowdService crowdService;

    public MembersOfFunction(UserUtil userUtil, CrowdService crowdService) {
        this.userUtil = userUtil;
        this.crowdService = crowdService;
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand functionOperand, TerminalClause terminalClause) {
        String groupName;
        Group group;
        I18nHelper i18n = this.getI18n();
        MessageSet messages = this.validateNumberOfArgs(functionOperand, 1);
        if (!messages.hasAnyErrors() && (group = this.getGroupsIgnoreCase(groupName = (String)functionOperand.getArgs().get(0))) == null) {
            messages.addErrorMessage(i18n.getText("jira.jql.group.no.such.group", functionOperand.getName(), groupName));
        }
        return messages;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        if (!operand.getArgs().isEmpty()) {
            String groupName = (String)operand.getArgs().get(0);
            Group group = this.getGroupsIgnoreCase(groupName);
            LinkedHashSet<QueryLiteral> usernames = new LinkedHashSet<QueryLiteral>();
            if (group != null) {
                Collections.singletonList(group);
                List<Group> groups = Collections.singletonList(group);
                SortedSet users = this.userUtil.getAllUsersInGroups(groups);
                if (users != null) {
                    for (ApplicationUser user : users) {
                        usernames.add(new QueryLiteral((Operand)operand, user.getName()));
                    }
                }
            }
            return new ArrayList<QueryLiteral>(usernames);
        }
        return Collections.emptyList();
    }

    private Group getGroupsIgnoreCase(String groupName) {
        return this.crowdService.getGroup(groupName);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.USER;
    }
}

