/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ServletActionContext;

public class JiraRendererModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<JiraRendererPlugin>
implements JiraRendererModuleDescriptor {
    public static final String TEMPLATE_NAME_CSS = "css";
    public static final String TEMPLATE_NAME_JS = "javascript";
    public static final String TEMPLATE_NAME_EDIT = "edit";
    private ApplicationProperties applicationProperties;

    public JiraRendererModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.applicationProperties = applicationProperties;
    }

    public String getCss() {
        HashMap<String, String> params = new HashMap<String, String>();
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        params.put("menuTxtColour", lookAndFeelBean.getMenuTxtColour());
        params.put("textHighlightColour", lookAndFeelBean.getTextHeadingColour());
        params.put("menuBackgroundColour", lookAndFeelBean.getMenuBackgroundColour());
        params.put("req", (String)ServletActionContext.getRequest());
        return this.getHtml(TEMPLATE_NAME_CSS, params);
    }

    public String getJavaScript(String contextPath) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("i18n", this.getI18nBean());
        params.put("contextPath", contextPath);
        return this.getHtml(TEMPLATE_NAME_JS, params);
    }

    public String getEditVM(String value, String issueKey, String rendererType, String fieldId, String fieldName, Map params, boolean singleLine) {
        if (!this.isResourceExist(TEMPLATE_NAME_EDIT)) {
            throw new IllegalStateException("An edit velocity template is a required resource for a renderer module.");
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        JiraRendererPlugin renderer = (JiraRendererPlugin)this.getModule();
        params.put("req", ServletActionContext.getRequest());
        params.put("fieldId", fieldId);
        params.put("fieldName", fieldName);
        params.put("issueKey", issueKey);
        params.put("rendererType", renderer.getRendererType());
        params.put("value", renderer.transformForEdit((Object)value));
        params.put("textutils", new TextUtils());
        params.put("i18n", this.getI18nBean());
        if (singleLine) {
            params.put("singleLine", Boolean.TRUE);
        }
        String editHtml = this.getHtml(TEMPLATE_NAME_EDIT, params);
        if (!renderer.getRendererType().equals(rendererType) && rendererType != null && !"null".equals(rendererType)) {
            editHtml = this.getI18nBean().getText("renderer.not.available.message", rendererType, this.getName()) + editHtml;
        }
        return editHtml;
    }

    public boolean isCSSTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_CSS);
    }

    public boolean isJavaScriptTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_JS);
    }

    public boolean isEditTemplateExists() {
        return this.isResourceExist(TEMPLATE_NAME_EDIT);
    }
}

