/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.report.ReportSubTaskFetcher;
import com.atlassian.jira.plugin.report.SubTaskInclusionOption;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.bean.PagerFilter;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeveloperWorkloadReport
extends AbstractReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeveloperWorkloadReport.class);
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final SearchProvider searchProvider;
    private final ReportSubTaskFetcher reportSubTaskFetcher;

    public DeveloperWorkloadReport(ProjectManager projectManager, ApplicationProperties applicationProperties, UserManager userManager, JiraDurationUtils jiraDurationUtils, SearchProvider searchProvider, ReportSubTaskFetcher reportSubTaskFetcher) {
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.jiraDurationUtils = jiraDurationUtils;
        this.userManager = userManager;
        this.searchProvider = searchProvider;
        this.reportSubTaskFetcher = reportSubTaskFetcher;
    }

    public boolean showReport() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    public void validate(ProjectActionSupport action, Map params) {
        super.validate(action, params);
        String developer = (String)params.get("developer");
        boolean canPickUsers = action.hasGlobalPermission(GlobalPermissionKey.USER_PICKER);
        if (!TextUtils.stringSet((String)developer)) {
            action.addError("developer", action.getText("report.developerworkload.developer.is.required"));
        } else if (!canPickUsers) {
            action.addError("developer", action.getText("report.developerworkload.developer.does.not.exist"));
        } else if (this.userManager.getUserByName(developer) == null) {
            action.addError("developer", action.getText("report.developerworkload.developer.does.not.exist"));
        }
    }

    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        ApplicationUser remoteUser = action.getLoggedInApplicationUser();
        ApplicationUser developer = this.userManager.getUserByName((String)reqParams.get("developer"));
        String subtaskInclusionKey = (String)reqParams.get("subtaskInclusion");
        SubTaskInclusionOption subtaskInclusion = subtaskInclusionKey == null ? SubTaskInclusionOption.ONLY_ASSIGNED : SubTaskInclusionOption.fromKey((String)subtaskInclusionKey);
        ArrayList<Issue> result = new ArrayList<Issue>();
        List<Issue> assignedIssues = this.initAssignedIssues(remoteUser, developer);
        result.addAll(assignedIssues);
        List subTasks = this.reportSubTaskFetcher.getSubTasksForUser(remoteUser, result, subtaskInclusion, true);
        result.addAll(subTasks);
        Map<Long, AbstractReport.MutableLong> countMap = this.initCountMap(result);
        Map<Long, AbstractReport.MutableLong> workloadMap = this.initWorkloadMap(result);
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("report", (Object)this);
        velocityParams.put("action", action);
        velocityParams.put("developer", developer);
        velocityParams.put("assignedIssues", result);
        velocityParams.put("countMap", countMap);
        velocityParams.put("workloadMap", workloadMap);
        velocityParams.put("totalCount", this.getTotalIssuesCount(countMap));
        velocityParams.put("totalWorkload", this.getTotalWorkload(workloadMap));
        return this.descriptor.getHtml("view", velocityParams);
    }

    public String formatPrettyDuration(Number v) {
        return this.jiraDurationUtils.getFormattedDuration(Long.valueOf(v.longValue()), this.descriptor.getI18nBean().getLocale());
    }

    List<Issue> initAssignedIssues(ApplicationUser remoteUser, ApplicationUser developer) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        builder.where().assigneeUser(developer.getUsername()).and().unresolved();
        try {
            SearchResults searchResults = this.searchProvider.search(builder.buildQuery(), remoteUser, PagerFilter.getUnlimitedFilter());
            return searchResults.getIssues();
        }
        catch (SearchException e) {
            LOGGER.error("Error executing Search Request in DeveloperWorkloadReport (remoteUser=" + remoteUser + ", developer=" + developer + "): " + (Object)((Object)e), (Throwable)e);
            return Collections.emptyList();
        }
    }

    Map<Long, AbstractReport.MutableLong> initCountMap(List<Issue> assignedIssues) {
        HashMap<Long, AbstractReport.MutableLong> countMap = new HashMap<Long, AbstractReport.MutableLong>();
        for (Issue assignedIssue : assignedIssues) {
            Long estimate = assignedIssue.getEstimate();
            if (estimate == null) continue;
            Long projectId = assignedIssue.getProjectId();
            AbstractReport.MutableLong counter = (AbstractReport.MutableLong)countMap.get(projectId);
            if (counter != null) {
                counter.incrementAndGet();
                continue;
            }
            countMap.put(projectId, new AbstractReport.MutableLong(1L));
        }
        return countMap;
    }

    Map<Long, AbstractReport.MutableLong> initWorkloadMap(List<Issue> assignedIssues) {
        HashMap<Long, AbstractReport.MutableLong> workloadMap = new HashMap<Long, AbstractReport.MutableLong>();
        for (Issue assignedIssue : assignedIssues) {
            Long projectId = assignedIssue.getProjectId();
            Long estimate = assignedIssue.getEstimate();
            if (estimate == null) continue;
            AbstractReport.MutableLong total = (AbstractReport.MutableLong)workloadMap.get(projectId);
            if (total != null) {
                total.add(estimate.longValue());
                continue;
            }
            workloadMap.put(projectId, new AbstractReport.MutableLong(estimate.longValue()));
        }
        return workloadMap;
    }

    public Long getTotalIssuesCount(Map<Long, AbstractReport.MutableLong> countMap) {
        long total = 0L;
        for (AbstractReport.MutableLong projectIssueCount : countMap.values()) {
            total += projectIssueCount.longValue();
        }
        return total;
    }

    public Long getTotalWorkload(Map<Long, AbstractReport.MutableLong> workloadMap) {
        long totalWorkload = 0L;
        for (AbstractReport.MutableLong projectWorkload : workloadMap.values()) {
            totalWorkload += projectWorkload.longValue();
        }
        return totalWorkload;
    }

    public String getProjectName(Long projectId) {
        return this.projectManager.getProjectObj(projectId).getName();
    }
}

