/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.ToStringBuilder;

public interface PluginsTracker {
    public boolean isPluginInvolved(Plugin var1);

    public boolean isPluginInvolved(ModuleDescriptor var1);

    public String getStateHashCode();

    public static class PluginInfo
    implements Comparable<PluginInfo> {
        private final String pluginKey;
        private final String pluginVersion;

        public PluginInfo(String pluginKey, String pluginVersion) {
            this.pluginKey = (String)Assertions.notNull((String)"pluginKey", (Object)pluginKey);
            this.pluginVersion = (String)Assertions.notNull((String)"pluginVersion", (Object)pluginVersion);
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        @Override
        public int compareTo(@Nonnull PluginInfo that) {
            int rc = this.pluginKey.compareTo(that.pluginKey);
            if (rc == 0) {
                rc = this.pluginVersion.compareTo(that.pluginVersion);
            }
            return rc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginInfo that = (PluginInfo)o;
            return this.pluginKey.equals(that.pluginKey) && this.pluginVersion.equals(that.pluginVersion);
        }

        public int hashCode() {
            int result = this.pluginKey.hashCode();
            result = 31 * result + this.pluginVersion.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

