/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webpanel.notification;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class IsWebSudoAuthenticated
implements Condition {
    private final InternalWebSudoManager internalWebSudoManager;
    private final JiraAuthenticationContext context;
    private final HttpServletVariables servlet;

    public IsWebSudoAuthenticated(InternalWebSudoManager internalWebSudoManager, JiraAuthenticationContext context, HttpServletVariables request) {
        this.internalWebSudoManager = (InternalWebSudoManager)Assertions.notNull((String)"internalWebSudoManager", (Object)internalWebSudoManager);
        this.context = (JiraAuthenticationContext)Assertions.notNull((String)"context", (Object)context);
        this.servlet = (HttpServletVariables)Assertions.notNull((String)"request", (Object)request);
    }

    public void init(Map<String, String> map) {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (!this.internalWebSudoManager.isEnabled()) {
            return false;
        }
        ApplicationUser user = this.context.getUser();
        if (user == null) {
            return false;
        }
        HttpServletRequest request = this.servlet.getHttpRequest();
        return this.internalWebSudoManager.hasValidSession(request.getSession(false));
    }
}

