/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.project.AssigneeTypes;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class ComponentAssigneeTypes
extends AssigneeTypes {
    private static final String NO_DEFAULT_MESSAGE = "Please select a Default Assignee";

    public static boolean isProjectDefault(Long defaultAssigneeType) {
        return defaultAssigneeType == null || defaultAssigneeType == 0L;
    }

    public static boolean isProjectLead(Long defaultAssigneeType) {
        return ComponentAssigneeTypes.isAssigneeType(defaultAssigneeType, 2L);
    }

    public static boolean isUnassigned(Long defaultAssigneeType) {
        return ComponentAssigneeTypes.isAssigneeType(defaultAssigneeType, 3L);
    }

    public static boolean isComponentLead(Long defaultAssigneeType) {
        return ComponentAssigneeTypes.isAssigneeType(defaultAssigneeType, 1L);
    }

    public static Map getAssigneeTypes(GenericValue component) {
        LinkedHashMap assigneesTypesMap = Maps.newLinkedHashMap();
        assigneesTypesMap.put(0L, "admin.assignee.type.project.default");
        if (ComponentAssigneeTypes.isAllowUnassigned()) {
            assigneesTypesMap.put(3L, "admin.assignee.type.unassigned");
        } else {
            assigneesTypesMap.put(-3L, "admin.assignee.type.not.allowed");
        }
        if (ComponentUtils.isProjectLeadAssignable(component)) {
            assigneesTypesMap.put(2L, "admin.assignee.type.project.lead");
        } else {
            assigneesTypesMap.put(-2L, "admin.assignee.type.not.assignable");
        }
        if (component.getString("lead") == null) {
            assigneesTypesMap.put(-1L, "admin.assignee.type.component.lead.not.exist");
        } else if (ComponentUtils.isComponentLeadAssignable(component)) {
            assigneesTypesMap.put(1L, "admin.assignee.type.component.lead");
        } else {
            assigneesTypesMap.put(-1L, "admin.assignee.type.component.lead.not.assignable");
        }
        return assigneesTypesMap;
    }

    private static boolean isAssigneeType(Long defaultAssigneeType, long assigneeType) {
        return defaultAssigneeType != null && defaultAssigneeType == assigneeType;
    }

    public static boolean isAssigneeTypeValid(GenericValue component, Long assigneeType) {
        return assigneeType == null || ComponentUtils.getAssigneeType(component, assigneeType) == assigneeType;
    }

    public static String getPrettyAssigneeType(Long defaultAssigneeType) {
        if (ComponentAssigneeTypes.isUnassigned(defaultAssigneeType)) {
            return "admin.assignee.type.unassigned";
        }
        if (ComponentAssigneeTypes.isComponentLead(defaultAssigneeType)) {
            return "admin.assignee.type.component.lead";
        }
        if (ComponentAssigneeTypes.isProjectDefault(defaultAssigneeType)) {
            return "admin.assignee.type.project.default";
        }
        if (ComponentAssigneeTypes.isProjectLead(defaultAssigneeType)) {
            return "admin.assignee.type.project.lead";
        }
        return NO_DEFAULT_MESSAGE;
    }
}

