/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.template.ProjectTemplate;
import com.atlassian.jira.project.template.ProjectTemplateBuilder;
import com.atlassian.jira.project.template.ProjectTemplateBuilderFactory;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.template.ProjectTemplateManager;
import com.atlassian.jira.project.template.descriptor.ProjectTemplateModuleDescriptor;
import com.atlassian.jira.project.template.module.ProjectTemplateModule;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ProjectTemplateManagerImpl
implements ProjectTemplateManager {
    static final ProjectTemplateKey JIRA_DEFAULT_TEMPLATE_KEY = new ProjectTemplateKey("com.atlassian.jira-legacy-project-templates:jira-blank-item");
    static final ProjectTemplateKey JIRA_DEFAULT_TEMPLATE_KEY_POST_7_0 = new ProjectTemplateKey("com.atlassian.jira-core-project-templates:jira-core-project-management");
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectTemplateBuilderFactory builderFactory;
    private final ApplicationAuthorizationService applicationAuthorizationService;

    public ProjectTemplateManagerImpl(PluginAccessor pluginAccessor, JiraAuthenticationContext authenticationContext, ProjectTemplateBuilderFactory builderFactory, ApplicationAuthorizationService applicationAuthorizationService) {
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.builderFactory = builderFactory;
        this.applicationAuthorizationService = applicationAuthorizationService;
    }

    public List<ProjectTemplate> getProjectTemplates() {
        return (List)this.findAllTemplateModules().filter(this::isDisplayable).map(this::toProjectTemplate).sorted().collect(CollectorsUtil.toImmutableList());
    }

    public Optional<ProjectTemplate> getProjectTemplate(ProjectTemplateKey projectTemplateKey) {
        return this.findByKeyVisible(projectTemplateKey);
    }

    public ProjectTemplate getDefaultTemplate() {
        ProjectTemplateKey key = this.applicationAuthorizationService.rolesEnabled() ? JIRA_DEFAULT_TEMPLATE_KEY_POST_7_0 : JIRA_DEFAULT_TEMPLATE_KEY;
        return this.getProjectTemplate(key).orElseThrow(() -> new IllegalStateException("The JIRA default schemes project template is not defined on this instance"));
    }

    private Stream<ProjectTemplateModuleDescriptor> findAllTemplateModules() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectTemplateModuleDescriptor.class).stream();
    }

    private boolean isDisplayable(ProjectTemplateModuleDescriptor moduleDescriptor) {
        return moduleDescriptor.getCondition().shouldDisplay((Map)ImmutableMap.of((Object)"helper", (Object)new JiraHelper(ExecutingHttpRequest.get()), (Object)"user", (Object)this.authenticationContext.getLoggedInUser()));
    }

    private ProjectTemplate toProjectTemplate(ProjectTemplateModuleDescriptor templateModuleDescriptor) {
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        ProjectTemplateModule template = templateModuleDescriptor.getModule();
        ProjectTemplateBuilder builder = this.builderFactory.newBuilder().key(StringUtils.isBlank((CharSequence)template.key()) ? "" : template.key()).weight(template.weight()).name(i18nHelper.getText(template.labelKey())).description(i18nHelper.getText(template.descriptionKey())).iconUrl(template.icon().url()).backgroundIconUrl(template.backgroundIcon().url()).infoSoyPath(template.getInfoSoyPath()).projectTypeKey(template.projectTypeKey());
        template.longDescriptionKey().ifPresent(key -> builder.longDescriptionContent(i18nHelper.getText(key)));
        if (template.hasAddProjectModule()) {
            builder.addProjectModule(template.addProjectModule());
        }
        return builder.build();
    }

    private Optional<ProjectTemplate> findByKeyVisible(ProjectTemplateKey key) {
        if (key == null || key.getKey() == null) {
            return Optional.empty();
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key.getKey());
        if (module == null) {
            return Optional.empty();
        }
        if (module instanceof ProjectTemplateModuleDescriptor) {
            ProjectTemplateModuleDescriptor template = (ProjectTemplateModuleDescriptor)module;
            return Optional.ofNullable(this.isDisplayable(template) ? this.toProjectTemplate(template) : null);
        }
        return Optional.empty();
    }
}

