/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class VersionImpl
implements Version {
    private final Long projectId;
    private final Long id;
    private final String name;
    private final String description;
    private final Long sequence;
    private final boolean archived;
    private final boolean released;
    private final Timestamp releaseDate;
    private final Timestamp startDate;
    private ProjectManager projectManager = null;

    public VersionImpl(Long projectId, Long id, String name) {
        this(projectId, id, name, null, null, false, false, null, null);
    }

    public VersionImpl(Long projectId, Long id, String name, String description, Long sequence, boolean archived, boolean released, Date releaseDate, Date startDate) {
        this.projectId = projectId;
        this.id = id;
        this.name = name;
        this.description = description;
        this.sequence = sequence;
        this.archived = archived;
        this.released = released;
        this.releaseDate = VersionImpl.copyDate(releaseDate);
        this.startDate = VersionImpl.copyDate(startDate);
    }

    public Project getProject() {
        return this.getProjectObject();
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Project getProjectObject() {
        if (this.projectManager == null) {
            this.projectManager = ComponentAccessor.getProjectManager();
        }
        return this.projectManager.getProjectObj(this.projectId);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isReleased() {
        return this.released;
    }

    @Nullable
    public Date getReleaseDate() {
        return VersionImpl.copyDate(this.releaseDate);
    }

    @Nullable
    public static Timestamp copyDate(@Nullable Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    public GenericValue toGenericValue() {
        GenericValue genericValue = ComponentAccessor.getOfBizDelegator().makeValue("Version");
        genericValue.set("project", (Object)this.projectId);
        genericValue.set("id", (Object)this.id);
        genericValue.setString("name", this.name);
        genericValue.setString("description", this.description);
        genericValue.set("sequence", (Object)this.sequence);
        genericValue.setString("archived", this.archived ? "true" : null);
        genericValue.setString("released", this.released ? "true" : null);
        genericValue.set("releasedate", (Object)VersionImpl.copyDate(this.releaseDate));
        genericValue.set("startdate", (Object)VersionImpl.copyDate(this.startDate));
        return genericValue;
    }

    @Nullable
    public Date getStartDate() {
        return VersionImpl.copyDate(this.startDate);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionImpl)) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        if (this.archived != version.archived) {
            return false;
        }
        if (this.released != version.released) {
            return false;
        }
        if (this.description != null ? !this.description.equals(version.description) : version.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(version.id) : version.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(version.name) : version.name != null) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(version.projectId) : version.projectId != null) {
            return false;
        }
        if (this.releaseDate != null ? !this.releaseDate.equals(version.releaseDate) : version.releaseDate != null) {
            return false;
        }
        if (this.sequence != null ? !this.sequence.equals(version.sequence) : version.sequence != null) {
            return false;
        }
        return !(this.startDate != null ? !this.startDate.equals(version.startDate) : version.startDate != null);
    }

    public int hashCode() {
        int result = this.projectId != null ? this.projectId.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.sequence != null ? this.sequence.hashCode() : 0);
        result = 31 * result + (this.archived ? 1 : 0);
        result = 31 * result + (this.released ? 1 : 0);
        result = 31 * result + (this.releaseDate != null ? this.releaseDate.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        return result;
    }
}

