/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.propertyset.PropertySetCache;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetSchema;
import com.opensymphony.util.DataUtil;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;

@Deprecated
public class JiraCachingPropertySet
implements PropertySet {
    private final Lock lock;
    private PropertySet decoratedPS;
    private PropertySetCache propertySetCache;

    public JiraCachingPropertySet() {
        this(new ReentrantLock());
    }

    @VisibleForTesting
    JiraCachingPropertySet(Lock lock) {
        Validate.notNull((Object)lock);
        this.lock = lock;
    }

    public void setAsActualType(String key, Object value) {
        if (value instanceof Boolean) {
            this.setBoolean(key, DataUtil.getBoolean((Boolean)((Boolean)value)));
        } else if (value instanceof Integer) {
            this.setInt(key, DataUtil.getInt((Integer)((Integer)value)));
        } else if (value instanceof Long) {
            this.setLong(key, DataUtil.getLong((Long)((Long)value)));
        } else if (value instanceof Double) {
            this.setDouble(key, DataUtil.getDouble((Double)((Double)value)));
        } else if (value instanceof String) {
            this.setString(key, (String)value);
        } else if (value instanceof Date) {
            this.setDate(key, (Date)value);
        } else if (value instanceof Document) {
            this.setXML(key, (Document)value);
        } else if (value instanceof byte[]) {
            this.setData(key, (byte[])value);
        } else if (value instanceof Properties) {
            this.setProperties(key, (Properties)value);
        } else {
            this.setObject(key, value);
        }
    }

    public Object getAsActualType(String key) {
        int type = this.getType(key);
        Object value = null;
        switch (type) {
            case 1: {
                value = this.getBoolean(key);
                break;
            }
            case 2: {
                value = this.getInt(key);
                break;
            }
            case 3: {
                value = this.getLong(key);
                break;
            }
            case 4: {
                value = this.getDouble(key);
                break;
            }
            case 5: {
                value = this.getString(key);
                break;
            }
            case 7: {
                value = this.getDate(key);
                break;
            }
            case 9: {
                value = this.getXML(key);
                break;
            }
            case 10: {
                value = this.getData(key);
                break;
            }
            case 11: {
                value = this.getProperties(key);
                break;
            }
            case 8: {
                value = this.getObject(key);
            }
        }
        return value;
    }

    public void setBoolean(final String key, final boolean value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setBoolean(key, value);
                JiraCachingPropertySet.this.propertySetCache.setBoolean(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        try {
            return this.propertySetCache.getBoolean(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                boolean bl = this.propertySetCache.getBoolean(key);
                return bl;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                boolean value = this.decoratedPS.getBoolean(key);
                this.propertySetCache.setBoolean(key, value);
                boolean bl = value;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setData(final String key, final byte[] value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setData(key, value);
                JiraCachingPropertySet.this.propertySetCache.setData(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String key) {
        try {
            return this.propertySetCache.getData(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                byte[] byArray = this.propertySetCache.getData(key);
                return byArray;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                byte[] value = this.decoratedPS.getData(key);
                this.propertySetCache.setData(key, value);
                byte[] byArray = value;
                return byArray;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setDate(final String key, final Date value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setDate(key, value);
                JiraCachingPropertySet.this.propertySetCache.setDate(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String key) {
        try {
            return this.propertySetCache.getDate(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Date date = this.propertySetCache.getDate(key);
                return date;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Date value = this.decoratedPS.getDate(key);
                this.propertySetCache.setDate(key, value);
                Date date = value;
                return date;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setDouble(final String key, final double value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setDouble(key, value);
                JiraCachingPropertySet.this.propertySetCache.setDouble(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String key) {
        try {
            return this.propertySetCache.getDouble(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                double d = this.propertySetCache.getDouble(key);
                return d;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                double value = this.decoratedPS.getDouble(key);
                this.propertySetCache.setDouble(key, value);
                double d = value;
                return d;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setInt(final String key, final int value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setInt(key, value);
                JiraCachingPropertySet.this.propertySetCache.setInt(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key) {
        try {
            return this.propertySetCache.getInt(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                int n = this.propertySetCache.getInt(key);
                return n;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                int value = this.decoratedPS.getInt(key);
                this.propertySetCache.setInt(key, value);
                int n = value;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Collection getKeys() {
        return this.decoratedPS.getKeys();
    }

    public Collection getKeys(int type) {
        return this.decoratedPS.getKeys(type);
    }

    public Collection getKeys(String prefix) {
        return this.decoratedPS.getKeys(prefix);
    }

    public Collection getKeys(String prefix, int type) {
        return this.decoratedPS.getKeys(prefix, type);
    }

    public void setLong(final String key, final long value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setLong(key, value);
                JiraCachingPropertySet.this.propertySetCache.setLong(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key) {
        try {
            return this.propertySetCache.getLong(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                long l = this.propertySetCache.getLong(key);
                return l;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                long value = this.decoratedPS.getLong(key);
                this.propertySetCache.setLong(key, value);
                long l = value;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setObject(final String key, final Object value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setObject(key, value);
                JiraCachingPropertySet.this.propertySetCache.setObject(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) {
        try {
            return this.propertySetCache.getObject(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Object object = this.propertySetCache.getObject(key);
                return object;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Object value = this.decoratedPS.getObject(key);
                this.propertySetCache.setObject(key, value);
                Object object = value;
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setProperties(final String key, final Properties value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setProperties(key, value);
                JiraCachingPropertySet.this.propertySetCache.setProperties(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String key) {
        try {
            return this.propertySetCache.getProperties(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Properties properties = this.propertySetCache.getProperties(key);
                return properties;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Properties value = this.decoratedPS.getProperties(key);
                this.propertySetCache.setProperties(key, value);
                Properties properties = value;
                return properties;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setSchema(PropertySetSchema schema) {
        this.decoratedPS.setSchema(schema);
    }

    public PropertySetSchema getSchema() {
        return this.decoratedPS.getSchema();
    }

    public boolean isSettable(String property) {
        return this.decoratedPS.isSettable(property);
    }

    public void setString(final String key, final String value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setString(key, value);
                JiraCachingPropertySet.this.propertySetCache.setString(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        try {
            return this.propertySetCache.getString(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                String string = this.propertySetCache.getString(key);
                return string;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                String value = this.decoratedPS.getString(key);
                this.propertySetCache.setObject(key, value);
                String string = value;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setText(final String key, final String value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setText(key, value);
                JiraCachingPropertySet.this.propertySetCache.setText(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(String key) {
        try {
            return this.propertySetCache.getText(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                String string = this.propertySetCache.getText(key);
                return string;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                String value = this.decoratedPS.getText(key);
                this.propertySetCache.setText(key, value);
                String string = value;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(String key) {
        try {
            return this.propertySetCache.getType(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                int n = this.propertySetCache.getType(key);
                return n;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                int value = this.decoratedPS.getType(key);
                this.propertySetCache.setType(key, value);
                int n = value;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setXML(final String key, final Document value) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.setXML(key, value);
                JiraCachingPropertySet.this.propertySetCache.setXML(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXML(String key) {
        try {
            return this.propertySetCache.getXML(key);
        }
        catch (PropertySetCache.NoValueCachedException ex) {
            this.lock.lock();
            try {
                Document document = this.propertySetCache.getXML(key);
                return document;
            }
            catch (PropertySetCache.NoValueCachedException ex2) {
                Document value = this.decoratedPS.getXML(key);
                this.propertySetCache.setXML(key, value);
                Document document = value;
                return document;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Boolean exists = this.propertySetCache.exists(key);
        if (exists != null) {
            return exists;
        }
        this.lock.lock();
        try {
            exists = this.propertySetCache.exists(key);
            if (exists != null) {
                boolean bl = exists;
                return bl;
            }
            boolean keyExists = this.decoratedPS.exists(key);
            this.propertySetCache.cacheExistance(key, keyExists);
            boolean bl = keyExists;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void init(Map config, final Map args) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS = (PropertySet)args.get("PropertySet");
                if (JiraCachingPropertySet.this.decoratedPS == null) {
                    throw new NullPointerException("Decorated property set is missing! Cannot initialise.");
                }
                JiraCachingPropertySet.this.propertySetCache = new PropertySetCache();
            }
        });
    }

    public void remove(final String key) {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.propertySetCache.remove(key);
                JiraCachingPropertySet.this.decoratedPS.remove(key);
            }
        });
    }

    public boolean supportsType(int type) {
        return this.decoratedPS.supportsType(type);
    }

    public boolean supportsTypes() {
        return this.decoratedPS.supportsTypes();
    }

    public void remove() throws PropertyException {
        this.doLocked(new Runnable(){

            @Override
            public void run() {
                JiraCachingPropertySet.this.decoratedPS.remove();
                JiraCachingPropertySet.this.propertySetCache.clear();
            }
        });
    }

    public void clearCache() {
        if (this.propertySetCache != null) {
            this.propertySetCache.clear();
        }
    }

    private void doLocked(Runnable runnable) {
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

