/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler.cron;

import com.atlassian.jira.scheduler.cron.ConversionResult;
import java.util.Calendar;
import java.util.Date;

public class SimpleToCronTriggerConverter {
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private static final long MONTHS = 2419200000L;
    private static final long YEARS = 29030400000L;
    private static final long[] TIME_UNITS = new long[]{1000L, 60000L, 3600000L, 86400000L, 2419200000L, 29030400000L};
    private static final long WEEK_FREQ_LOWER_BOUND = 345600000L;
    private static final long WEEK_FREQ_UPPER_BOUND = 864000000L;
    private static final int CRON_SECONDS = 0;
    private static final int CRON_MINUTES = 1;
    private static final int CRON_HOURS = 2;
    private static final int CRON_DAYOFMONTH = 3;
    private static final int CRON_MONTH = 4;
    private static final int CRON_DAYOFWEEK = 5;
    private static final String CRON_WILDCARD = "*";
    private static final String CRON_NOT_APPLICABLE = "?";
    private static final int ZERO_BASED = 0;
    private static final int ONE_BASED = 1;

    public ConversionResult convertToCronString(Date nextFireDate, long intervalMs) {
        Calendar nextFire = Calendar.getInstance();
        nextFire.setTime(nextFireDate);
        nextFire.set(13, 0);
        nextFire.set(12, nextFire.get(12) / 5 * 5);
        long baseTimeUnit = this.determineBaseTimeUnit(intervalMs);
        long roundedInterval = this.roundInterval(intervalMs, baseTimeUnit);
        boolean hasLoss = roundedInterval * baseTimeUnit != intervalMs || baseTimeUnit > 604800000L;
        String[] cronArray = new String[6];
        if (roundedInterval * baseTimeUnit > 345600000L && roundedInterval * baseTimeUnit < 864000000L) {
            cronArray[0] = String.valueOf(nextFire.get(13));
            cronArray[1] = String.valueOf(nextFire.get(12));
            cronArray[2] = String.valueOf(nextFire.get(11));
            cronArray[3] = CRON_NOT_APPLICABLE;
            cronArray[4] = CRON_WILDCARD;
            cronArray[5] = String.valueOf(nextFire.get(7));
        } else if (baseTimeUnit == 1000L) {
            cronArray[0] = this.makeIncrementalCronElement(nextFire.get(13), roundedInterval, 0);
            cronArray[1] = CRON_WILDCARD;
            cronArray[2] = CRON_WILDCARD;
            cronArray[3] = CRON_WILDCARD;
            cronArray[4] = CRON_WILDCARD;
            cronArray[5] = CRON_NOT_APPLICABLE;
        } else if (baseTimeUnit == 60000L) {
            cronArray[0] = String.valueOf(nextFire.get(13));
            cronArray[1] = this.makeIncrementalCronElement(nextFire.get(12), roundedInterval, 0);
            cronArray[2] = CRON_WILDCARD;
            cronArray[3] = CRON_WILDCARD;
            cronArray[4] = CRON_WILDCARD;
            cronArray[5] = CRON_NOT_APPLICABLE;
        } else if (baseTimeUnit == 3600000L) {
            cronArray[0] = String.valueOf(nextFire.get(13));
            cronArray[1] = String.valueOf(nextFire.get(12));
            cronArray[2] = this.makeIncrementalCronElement(nextFire.get(11), roundedInterval, 0);
            cronArray[3] = CRON_WILDCARD;
            cronArray[4] = CRON_WILDCARD;
            cronArray[5] = CRON_NOT_APPLICABLE;
        } else if (baseTimeUnit == 86400000L) {
            cronArray[0] = String.valueOf(nextFire.get(13));
            cronArray[1] = String.valueOf(nextFire.get(12));
            cronArray[2] = String.valueOf(nextFire.get(11));
            cronArray[3] = this.makeIncrementalCronElement(nextFire.get(5), roundedInterval, 1);
            cronArray[4] = CRON_WILDCARD;
            cronArray[5] = CRON_NOT_APPLICABLE;
        } else if (baseTimeUnit == 2419200000L) {
            cronArray[0] = String.valueOf(nextFire.get(13));
            cronArray[1] = String.valueOf(nextFire.get(12));
            cronArray[2] = String.valueOf(nextFire.get(11));
            cronArray[3] = String.valueOf(nextFire.get(5));
            cronArray[4] = this.makeIncrementalCronElement(nextFire.get(2) + 1, roundedInterval, 1);
            cronArray[5] = CRON_NOT_APPLICABLE;
        } else if (baseTimeUnit == 29030400000L) {
            cronArray[0] = String.valueOf(nextFire.get(13));
            cronArray[1] = String.valueOf(nextFire.get(12));
            cronArray[2] = String.valueOf(nextFire.get(11));
            cronArray[3] = String.valueOf(nextFire.get(5));
            cronArray[4] = String.valueOf(nextFire.get(2) + 1);
            cronArray[5] = CRON_NOT_APPLICABLE;
        } else {
            throw new RuntimeException("Invalid base time unit: " + baseTimeUnit + "ms");
        }
        StringBuilder cronString = new StringBuilder();
        for (String aCronArray : cronArray) {
            cronString.append(aCronArray);
            cronString.append(" ");
        }
        return new ConversionResult(hasLoss, cronString.toString());
    }

    protected String makeIncrementalCronElement(int targetTime, long frequency, int base) {
        long cronStart;
        if (base != 0 && base != 1) {
            throw new RuntimeException("Invalid base (" + base + ") for cron element.");
        }
        if (frequency == 1L) {
            return CRON_WILDCARD;
        }
        if ((long)targetTime >= frequency) {
            cronStart = (long)targetTime % frequency;
            if (base == 1 && cronStart == 0L) {
                cronStart = frequency;
            }
        } else {
            cronStart = targetTime;
        }
        return cronStart + "/" + frequency;
    }

    protected long roundInterval(long intervalMs, long baseTimeUnit) {
        if (baseTimeUnit >= intervalMs) {
            return 1L;
        }
        if (baseTimeUnit == 29030400000L) {
            return 1L;
        }
        long nextTimeUnit = this.getSucceedingTimeUnit(baseTimeUnit);
        int i = 2;
        long potentialFactor;
        while (nextTimeUnit % (long)i != 0L || (potentialFactor = nextTimeUnit / (long)i) % baseTimeUnit != 0L || intervalMs < potentialFactor) {
            if ((long)i > nextTimeUnit / baseTimeUnit) {
                throw new RuntimeException("calculateRoundedFrequency malfunction for nextTimeUnit=" + nextTimeUnit + " baseTimeUnit=" + baseTimeUnit);
            }
            ++i;
        }
        return potentialFactor / baseTimeUnit;
    }

    protected long getSucceedingTimeUnit(long timeUnit) {
        if (timeUnit >= 29030400000L) {
            throw new IllegalArgumentException("Years are the upper limit of our subscription service granularity.");
        }
        for (int i = 0; i < TIME_UNITS.length - 1; ++i) {
            if (timeUnit != TIME_UNITS[i]) continue;
            return TIME_UNITS[i + 1];
        }
        throw new IllegalArgumentException("Invalid time unit.");
    }

    protected long determineBaseTimeUnit(long intervalMs) {
        for (int i = 0; i < TIME_UNITS.length - 1; ++i) {
            long nextTimeUnit = TIME_UNITS[i + 1];
            if (intervalMs > nextTimeUnit) continue;
            long timeUnit = TIME_UNITS[i];
            return nextTimeUnit - intervalMs < intervalMs - timeUnit ? nextTimeUnit : timeUnit;
        }
        return TIME_UNITS[TIME_UNITS.length - 1];
    }
}

