/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.flag.FlagDismissalService;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.dbc.Assertions;
import javax.inject.Inject;

@EventComponent
public class AdminIssueLockoutFlagManager {
    public static final String FLAG = "admin.lockout";
    private final GlobalPermissionManager globalPermissionManager;
    private final FlagDismissalService flagDismissalService;
    private final ApplicationRoleManager applicationRoleManager;

    @Inject
    public AdminIssueLockoutFlagManager(GlobalPermissionManager globalPermissionManager, FlagDismissalService flagDismissalService, ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((String)"globalPermissionManager", (Object)globalPermissionManager);
        this.flagDismissalService = (FlagDismissalService)Assertions.notNull((String)"flagDismissalService", (Object)flagDismissalService);
    }

    @EventListener
    public void removeDismissalOnLogin(LoginEvent loginEvent) {
        ApplicationUser user = loginEvent.getUser();
        if (this.applicationRoleManager.rolesEnabled() && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && this.applicationRoleManager.hasAnyRole(user)) {
            this.flagDismissalService.removeDismissFlagForUser(FLAG, user);
        }
    }

    public boolean isAdminWithoutIssuePermission(ApplicationUser user) {
        return this.applicationRoleManager.rolesEnabled() && !Users.isAnonymous((ApplicationUser)user) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && !this.applicationRoleManager.hasAnyRole(user);
    }
}

