/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationRequiredPermissionManager
implements PermissionManager {
    private final PermissionManager permissionManager;

    public ApplicationRequiredPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
    }

    public Collection<ProjectPermission> getAllProjectPermissions() {
        return this.permissionManager.getAllProjectPermissions();
    }

    public Collection<ProjectPermission> getProjectPermissions(@Nonnull ProjectPermissionCategory category) {
        return this.permissionManager.getProjectPermissions(category);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        return this.permissionManager.hasPermission(permissionsId, user);
    }

    public Option<ProjectPermission> getProjectPermission(@Nonnull ProjectPermissionKey permissionKey) {
        return this.permissionManager.getProjectPermission(permissionKey);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionsId, issue, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionKey, issue, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionKey, issue, user, actionDescriptor));
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionsId, project, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionKey, project, user));
    }

    @Nonnull
    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrElse(user, () -> this.permissionManager.hasProjectWidePermission(permissionKey, project, user), () -> ProjectWidePermission.NO_ISSUES);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionsId, project, user, issueCreation));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasPermission(permissionKey, project, user, issueCreation));
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        this.permissionManager.removeGroupPermissions(group);
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        this.permissionManager.removeUserPermissions(user);
    }

    @Deprecated
    public boolean hasProjects(int permissionId, ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasProjects(permissionId, user));
    }

    public boolean hasProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, () -> this.permissionManager.hasProjects(permissionKey, user));
    }

    @Deprecated
    public Collection<Project> getProjects(int permissionId, ApplicationUser user) {
        return this.checkUserHasApplicationOrEmpty(user, () -> this.permissionManager.getProjects(permissionId, user));
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrEmpty(user, () -> this.permissionManager.getProjects(permissionKey, user));
    }

    @Deprecated
    public Collection<Project> getProjects(int permissionId, ApplicationUser user, ProjectCategory projectCategory) {
        return this.checkUserHasApplicationOrEmpty(user, () -> this.permissionManager.getProjects(permissionId, user, projectCategory));
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user, @Nullable ProjectCategory projectCategory) {
        return this.checkUserHasApplicationOrEmpty(user, () -> this.permissionManager.getProjects(permissionKey, user, projectCategory));
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        return this.permissionManager.getAllGroups(permissionId, project);
    }

    private ApplicationRoleManager applicationRoleManager() {
        return (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
    }

    private boolean checkUserHasApplicationOrFalse(ApplicationUser user, BooleanSupplier delegate) {
        GlobalPermissionManager globalPermissions = ComponentAccessor.getGlobalPermissionManager();
        ApplicationRoleManager roleManager = this.applicationRoleManager();
        return (!roleManager.rolesEnabled() || !globalPermissions.hasPermission(GlobalPermissionKey.ADMINISTER, user) || roleManager.hasAnyRole(user)) && delegate.getAsBoolean();
    }

    private Collection<Project> checkUserHasApplicationOrEmpty(ApplicationUser user, Supplier<Collection<Project>> delegate) {
        return this.checkUserHasApplicationOrElse(user, delegate, ImmutableList::of);
    }

    private <T> T checkUserHasApplicationOrElse(ApplicationUser user, Supplier<T> application, Supplier<? extends T> noApplication) {
        GlobalPermissionManager globalPermissions = ComponentAccessor.getGlobalPermissionManager();
        ApplicationRoleManager roleManager = this.applicationRoleManager();
        if (!roleManager.rolesEnabled() || !globalPermissions.hasPermission(GlobalPermissionKey.ADMINISTER, user) || roleManager.hasAnyRole(user)) {
            return application.get();
        }
        return noApplication.get();
    }
}

