/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationBuilder;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationData;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationStore;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class DefaultTrustedApplicationStore
implements TrustedApplicationStore {
    private final OfBizDelegator ofBizDelegator;

    public DefaultTrustedApplicationStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public TrustedApplicationData getById(long id) {
        return this.transform(this.findGenericValue(id));
    }

    @Override
    public TrustedApplicationData getByApplicationId(String applicationId) {
        return this.transform(this.findGenericValue(applicationId));
    }

    @Override
    public Set<TrustedApplicationData> getAll() {
        List all = this.ofBizDelegator.findAll("TrustedApplication");
        LinkedHashSet<TrustedApplicationData> result = new LinkedHashSet<TrustedApplicationData>();
        for (GenericValue element : all) {
            result.add(this.transform(element));
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public TrustedApplicationData store(TrustedApplicationData trustedApplicationData) {
        GenericValue oldValue;
        Map<String, Object> map = new TrustedApplicationBuilder().set(trustedApplicationData).toMap();
        GenericValue genericValue = oldValue = trustedApplicationData.getId() > 0L ? this.findGenericValue(trustedApplicationData.getId()) : null;
        if (oldValue == null) {
            GenericValue newValue = this.ofBizDelegator.createValue("TrustedApplication", map);
            return this.transform(newValue);
        }
        GenericValue newValue = new GenericValue(oldValue);
        newValue.setFields(map);
        this.ofBizDelegator.store(newValue);
        return trustedApplicationData;
    }

    @Override
    public boolean delete(long id) {
        return this.ofBizDelegator.removeByAnd("TrustedApplication", this.getIdQuery(id)) > 0;
    }

    @Override
    public boolean delete(String applicationId) {
        return this.ofBizDelegator.removeByAnd("TrustedApplication", this.getApplicationIdQuery(applicationId)) > 0;
    }

    private GenericValue findGenericValue(String applicationId) {
        return this.find(new PrimitiveMap.Builder().add("applicationId", applicationId).toMap());
    }

    private GenericValue findGenericValue(long id) {
        return this.find(this.getIdQuery(id));
    }

    private Map<String, Object> getIdQuery(long id) {
        return new PrimitiveMap.Builder().add("id", id).toMap();
    }

    private Map<String, Object> getApplicationIdQuery(String id) {
        return new PrimitiveMap.Builder().add("applicationId", id).toMap();
    }

    private GenericValue find(Map<String, Object> query) {
        List list = this.ofBizDelegator.findByAnd("TrustedApplication", query);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("There's more than one TrustedApplication in the database with the same ID: " + query);
        }
        return (GenericValue)list.get(0);
    }

    private TrustedApplicationData transform(GenericValue gv) {
        return gv == null ? null : new TrustedApplicationBuilder().set(gv).toData();
    }
}

