/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.SqlPredicates;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.model.querydsl.QUser;
import com.atlassian.jira.security.groups.UserIsNotShadowedPredicate;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.DslExpression;
import com.mysema.query.types.expr.Wildcard;
import java.util.Collection;
import java.util.stream.Collectors;

public class CountUsersInGroupQueryCallback
implements QueryCallback<Long> {
    private static final int SQL_SERVER_USE_LITERALS_THRESHOLD = 1900;
    private final Long directoryId;
    private final UserIsNotShadowedPredicate userIsNotShadowedPredicate;
    private final Collection<String> lowerCaseGroupNames;
    private final DatabaseConfig dbConfig;
    private final SqlPredicates sqlPredicates;

    public CountUsersInGroupQueryCallback(Long directoryId, Collection<Long> higherPriorityDirectoryIds, Collection<String> groupNames, DatabaseConfig dbConfig) {
        this.directoryId = directoryId;
        this.userIsNotShadowedPredicate = new UserIsNotShadowedPredicate(higherPriorityDirectoryIds);
        this.lowerCaseGroupNames = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        this.dbConfig = dbConfig;
        this.sqlPredicates = new SqlPredicates(dbConfig);
    }

    @Override
    public Long runQuery(DbConnection dbConnection) {
        if (this.dbConfig.isMySql()) {
            return this.runMySqlQuery(dbConnection);
        }
        return this.runStandardQuery(dbConnection);
    }

    private Long runStandardQuery(DbConnection dbConnection) {
        QMembership m = new QMembership("m");
        QUser u = new QUser("u");
        BooleanExpression userIsNotShadowed = this.userIsNotShadowedPredicate.apply(u);
        BooleanExpression userIsMemberOfGroups = ((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)m)).where((Predicate)m.lowerChildName.eq((Expression)u.lowerUserName).and((Predicate)m.membershipType.eq((Object)"GROUP_USER")).and((Predicate)m.directoryId.eq((Object)this.directoryId)).and(this.sqlPredicates.partitionedIn(m.lowerParentName, this.lowerCaseGroupNames)))).exists();
        SQLQuery query = (SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)u)).where((Predicate)u.active.eq((Object)1).and((Predicate)u.directoryId.eq((Object)this.directoryId)).and((Predicate)userIsNotShadowed).and((Predicate)userIsMemberOfGroups));
        if (this.dbConfig.isSqlServer() && this.lowerCaseGroupNames.size() > 1900) {
            query.setUseLiterals(true);
        }
        return (Long)query.singleResult((Expression)u.lowerUserName.count());
    }

    private Long runMySqlQuery(DbConnection dbConnection) {
        QMembership m = new QMembership("m");
        QUser u = new QUser("u");
        BooleanExpression userIsNotShadowed = this.userIsNotShadowedPredicate.apply(u);
        SQLSubQuery uniqueUsersSubQuery = (SQLSubQuery)((SQLSubQuery)((SQLSubQuery)((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)m)).innerJoin((EntityPath)u)).on((Predicate)u.id.eq(m.childId))).where((Predicate)u.active.eq((Object)1).and((Predicate)m.membershipType.eq((Object)"GROUP_USER")).and((Predicate)m.directoryId.eq((Object)this.directoryId)).and((Predicate)userIsNotShadowed).and((Predicate)m.lowerParentName.in(this.lowerCaseGroupNames)))).groupBy((Expression)m.lowerChildName);
        DslExpression uniqueUsers = uniqueUsersSubQuery.list((Expression)m.lowerChildName).as("uniqueUsers");
        SQLQuery countQuery = dbConnection.newSqlQuery();
        countQuery.from((Expression)uniqueUsers);
        return (Long)countQuery.singleResult((Expression)Wildcard.count);
    }
}

