/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.security.groups.CountUsersInGroupQueryCallback;
import com.atlassian.jira.security.groups.FilterUsersInAllGroupsQueryCallback;
import com.atlassian.jira.security.groups.GetUsersInGroupQueryCallback;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.JiraCollectionUtils;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.Pages;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupManager
implements GroupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultGroupManager.class);
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;
    private final DbConnectionManager dbConnectionManager;
    private final DatabaseConfigurationManager dbConfigManager;

    public DefaultGroupManager(CrowdService crowdService, DirectoryManager directoryManager, DbConnectionManager dbConnectionManager, DatabaseConfigurationManager dbConfigManager) {
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.dbConnectionManager = dbConnectionManager;
        this.dbConfigManager = dbConfigManager;
    }

    public Collection<Group> getAllGroups() {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)restriction, 0, -1);
        return JiraCollectionUtils.convertIterableToCollection(this.crowdService.search((Query)query));
    }

    public boolean groupExists(String groupName) {
        return this.getGroup(groupName) != null;
    }

    public boolean groupExists(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        return this.groupExists(group.getName());
    }

    public Group createGroup(String groupName) throws OperationNotPermittedException, InvalidGroupException {
        return this.crowdService.addGroup((Group)new ImmutableGroup(groupName));
    }

    public Group getGroup(String groupName) {
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroupEvenWhenUnknown(String groupName) {
        if (this.groupExists(groupName)) {
            return this.getGroup(groupName);
        }
        return new ImmutableGroup(groupName);
    }

    public Group getGroupObject(String groupName) {
        return this.getGroup(groupName);
    }

    public boolean isUserInGroup(@Nullable String username, @Nullable String groupname) {
        return username != null && groupname != null && this.crowdService.isUserMemberOfGroup(username, groupname);
    }

    public boolean isUserInGroup(@Nullable ApplicationUser user, @Nullable Group group) {
        return group != null && this.isUserInGroup(user, group.getName());
    }

    public boolean isUserInGroup(@Nullable ApplicationUser user, @Nullable String groupname) {
        return user != null && groupname != null && this.isUserInGroup(user.getDirectoryId(), user.getUsername(), groupname);
    }

    private boolean isUserInGroup(long directoryId, @Nonnull String username, @Nonnull String groupname) {
        try {
            return this.directoryManager.isUserNestedGroupMember(directoryId, username, groupname);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory mapping was removed while determining if user is a nested group member: " + e.getMessage());
        }
    }

    public Collection<ApplicationUser> getUsersInGroup(String groupName) {
        Iterable<User> usersIterable = this.getAllUsersInGroup(groupName);
        return ApplicationUsers.from(JiraCollectionUtils.convertIterableToCollection(usersIterable));
    }

    public Collection<ApplicationUser> getUsersInGroup(String groupName, Boolean includeInactive) {
        Iterable<User> usersIterable = this.getAllUsersInGroup(groupName);
        List<ApplicationUser> applicationUsers = ApplicationUsers.from(usersIterable);
        if (applicationUsers == null) {
            return null;
        }
        return applicationUsers.stream().filter(u -> includeInactive != false || u.isActive()).collect(Collectors.toList());
    }

    private Iterable<User> getAllUsersInGroup(String groupName) {
        return this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
    }

    public Page<ApplicationUser> getUsersInGroup(String groupName, Boolean includeInactive, PageRequest pageRequest) {
        Iterable<User> allUsersInGroup = this.getAllUsersInGroup(groupName);
        return Pages.toPage(allUsersInGroup, (PageRequest)pageRequest, u -> includeInactive != false || u.isActive(), ApplicationUsers::from);
    }

    public Collection<ApplicationUser> getUsersInGroup(Group group) {
        return this.getUsersInGroup(group.getName());
    }

    public int getUsersInGroupCount(Group group) {
        return this.getUsersInGroupCount(group.getName());
    }

    public int getUsersInGroupCount(String groupName) {
        List<Long> activeDirectoryIds = this.getActiveDirectoryIds();
        int totalCount = 0;
        int index = 0;
        for (Long directoryId : activeDirectoryIds) {
            Collection<String> expandedGroupNames = this.expandGroupNames(groupName, directoryId);
            if (expandedGroupNames.isEmpty()) {
                ++index;
                continue;
            }
            List<Long> higherPriorityDirectoryIds = activeDirectoryIds.subList(0, index++);
            CountUsersInGroupQueryCallback countUsersQuery = new CountUsersInGroupQueryCallback(directoryId, higherPriorityDirectoryIds, expandedGroupNames, this.dbConfigManager.getDatabaseConfiguration());
            long userCount = this.dbConnectionManager.executeQuery(countUsersQuery);
            totalCount = (int)((long)totalCount + userCount);
        }
        return totalCount;
    }

    public List<String> getNamesOfDirectMembersOfGroups(Collection<String> groupNames, int limit) {
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> activeDirectoryIds = this.getActiveDirectoryIds();
        List<String> allUserNames = new ArrayList<String>();
        int index = 0;
        for (Long directoryId : activeDirectoryIds) {
            List<String> groupsInDirectory = this.getGroupsInDirectory(groupNames, directoryId);
            if (groupsInDirectory.isEmpty()) {
                ++index;
                continue;
            }
            List<Long> higherPriorityDirectoryIds = activeDirectoryIds.subList(0, index++);
            GetUsersInGroupQueryCallback getUsersQuery = new GetUsersInGroupQueryCallback(directoryId, higherPriorityDirectoryIds, groupsInDirectory, limit, this.dbConfigManager.getDatabaseConfiguration());
            List<String> userNamesInDirectory = this.dbConnectionManager.executeQuery(getUsersQuery);
            allUserNames.addAll(userNamesInDirectory);
        }
        Collections.sort(allUserNames);
        if (allUserNames.size() > limit) {
            allUserNames = allUserNames.subList(0, limit);
        }
        return allUserNames;
    }

    public Collection<String> filterUsersInAllGroupsDirect(Collection<String> userNames, Collection<String> groupNames) {
        if (userNames.isEmpty() || groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> activeDirectoryIds = this.getActiveDirectoryIds();
        HashMultimap userToGroupMap = HashMultimap.create();
        int index = 0;
        for (Long directoryId : activeDirectoryIds) {
            List<String> groupsInDirectory = this.getGroupsInDirectory(groupNames, directoryId);
            if (groupsInDirectory.isEmpty()) {
                ++index;
                continue;
            }
            List<Long> higherPriorityDirectoryIds = activeDirectoryIds.subList(0, index++);
            FilterUsersInAllGroupsQueryCallback getUsersQuery = new FilterUsersInAllGroupsQueryCallback(directoryId, higherPriorityDirectoryIds, userNames, groupsInDirectory, this.dbConfigManager.getDatabaseConfiguration());
            List<FilterUsersInAllGroupsQueryCallback.Result> results = this.dbConnectionManager.executeQuery(getUsersQuery);
            for (FilterUsersInAllGroupsQueryCallback.Result result : results) {
                userToGroupMap.put((Object)IdentifierUtils.toLowerCase((String)result.getUserName()), (Object)IdentifierUtils.toLowerCase((String)result.getGroupName()));
            }
        }
        return userNames.stream().filter(arg_0 -> DefaultGroupManager.lambda$filterUsersInAllGroupsDirect$396((Multimap)userToGroupMap, groupNames, arg_0)).collect(Collectors.toSet());
    }

    private List<Long> getActiveDirectoryIds() {
        return this.directoryManager.findAllDirectories().stream().filter(Directory::isActive).map(Directory::getId).collect(Collectors.toList());
    }

    private List<String> getGroupsInDirectory(Collection<String> groupNames, long directoryId) {
        Collection groupNameRestrictions = groupNames.stream().map(groupName -> Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching(groupName)).collect(Collectors.toList());
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Combine.anyOf((Collection)groupNameRestrictions)).returningAtMost(-1);
        try {
            return this.directoryManager.searchGroups(directoryId, query);
        }
        catch (DirectoryNotFoundException | com.atlassian.crowd.exception.OperationFailedException e) {
            log.debug("Directory " + directoryId + " may have been removed while testing group existence", e);
            return Collections.emptyList();
        }
    }

    private Collection<String> expandGroupNames(String groupName, long directoryId) {
        List<String> expandedGroups = this.getGroupsInDirectory(Collections.singletonList(groupName), directoryId);
        if (expandedGroups.isEmpty() || !this.nestedGroupsEnabled(directoryId)) {
            return expandedGroups;
        }
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        try {
            expandedGroups.addAll(this.directoryManager.searchNestedGroupRelationships(directoryId, membershipQuery));
        }
        catch (DirectoryNotFoundException | com.atlassian.crowd.exception.OperationFailedException e) {
            log.debug("Directory " + directoryId + " may have been removed while expanding group names", e);
        }
        return expandedGroups;
    }

    private boolean nestedGroupsEnabled(long directoryId) {
        try {
            return this.directoryManager.supportsNestedGroups(directoryId);
        }
        catch (DirectoryInstantiationException | DirectoryNotFoundException e) {
            log.debug("Directory " + directoryId + " was missing", e);
            return false;
        }
    }

    public Collection<String> getUserNamesInGroup(Group group) {
        return this.getUserNamesInGroup(group.getName());
    }

    public Collection<String> getUserNamesInGroups(Collection<Group> groups) {
        ArrayList users = Lists.newArrayList();
        for (Group group : groups) {
            users.addAll(this.getUserNamesInGroup(group));
        }
        return ImmutableSet.copyOf((Collection)users);
    }

    public Collection<String> getUserNamesInGroup(String groupName) {
        Iterable usersIterable = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        return JiraCollectionUtils.convertIterableToCollection(usersIterable);
    }

    public Collection<ApplicationUser> getDirectUsersInGroup(Group group) {
        Collection<ApplicationUser> usersInGroup = this.getUsersInGroup(group.getName());
        Iterator<ApplicationUser> iter = usersInGroup.iterator();
        while (iter.hasNext()) {
            if (this.crowdService.isUserDirectGroupMember(iter.next().getDirectoryUser(), group)) continue;
            iter.remove();
        }
        return usersInGroup;
    }

    public Collection<Group> getGroupsForUser(String userName) {
        Iterable searchResults = this.crowdService.search((Query)QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1));
        return JiraCollectionUtils.convertIterableToCollection(searchResults);
    }

    public Collection<Group> getGroupsForUser(@Nonnull ApplicationUser user) {
        return this.getGroupsForUser(user.getName());
    }

    public Collection<String> getGroupNamesForUser(String userName) {
        Iterable usersIterable = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1));
        return JiraCollectionUtils.convertIterableToCollection(usersIterable);
    }

    public Collection<String> getGroupNamesForUser(@Nonnull ApplicationUser user) {
        return this.getGroupNamesForUser(user.getName());
    }

    public void addUserToGroup(ApplicationUser user, Group group) throws GroupNotFoundException, UserNotFoundException, OperationNotPermittedException, com.atlassian.crowd.exception.OperationFailedException {
        this.crowdService.addUserToGroup(user.getDirectoryUser(), group);
    }

    private static /* synthetic */ boolean lambda$filterUsersInAllGroupsDirect$396(Multimap userToGroupMap, Collection groupNames, String userName) {
        return userToGroupMap.get((Object)IdentifierUtils.toLowerCase((String)userName)).size() == groupNames.size();
    }
}

