/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.groups;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.SqlPredicates;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.model.querydsl.QUser;
import com.atlassian.jira.security.groups.UserIsNotShadowedPredicate;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class GetUsersInGroupQueryCallback
implements QueryCallback<List<String>> {
    private static final int SQL_SERVER_USE_LITERALS_THRESHOLD = 1900;
    private final Long directoryId;
    private final UserIsNotShadowedPredicate userIsNotShadowedPredicate;
    private final Collection<String> lowerCaseGroupNames;
    private final DatabaseConfig dbConfig;
    private final SqlPredicates sqlPredicates;
    private final int limit;

    public GetUsersInGroupQueryCallback(Long directoryId, Collection<Long> higherPriorityDirectoryIds, Collection<String> groupNames, int limit, DatabaseConfig dbConfig) {
        this.directoryId = directoryId;
        this.userIsNotShadowedPredicate = new UserIsNotShadowedPredicate(higherPriorityDirectoryIds);
        this.lowerCaseGroupNames = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        this.limit = limit;
        this.dbConfig = dbConfig;
        this.sqlPredicates = new SqlPredicates(dbConfig);
    }

    @Override
    public List<String> runQuery(DbConnection dbConnection) {
        QMembership m = new QMembership("m");
        QUser u = new QUser("u");
        BooleanExpression userIsNotShadowed = this.userIsNotShadowedPredicate.apply(u);
        BooleanExpression userIsMemberOfGroups = ((SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)m)).where((Predicate)m.lowerChildName.eq((Expression)u.lowerUserName).and((Predicate)m.membershipType.eq((Object)"GROUP_USER")).and((Predicate)m.directoryId.eq((Object)this.directoryId)).and(this.sqlPredicates.partitionedIn(m.lowerParentName, this.lowerCaseGroupNames)))).exists();
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)u)).where((Predicate)u.active.eq((Object)1).and((Predicate)u.directoryId.eq((Object)this.directoryId)).and((Predicate)userIsNotShadowed).and((Predicate)userIsMemberOfGroups))).orderBy(u.lowerUserName.asc())).limit((long)this.limit);
        if (this.dbConfig.isSqlServer() && this.lowerCaseGroupNames.size() > 1900) {
            query.setUseLiterals(true);
        }
        return query.list((Expression)u.userName);
    }
}

